/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.parser.field;

import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.And;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.field.value.SpecialCharFieldValue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class FieldParser {
    private final char[] specialCharsMinusStar = new char[]{'/', '-', ','};
    private FieldConstraints constraints;

    public FieldParser(FieldConstraints constraints) {
        this.constraints = (FieldConstraints)Validate.notNull((Object)constraints, (String)"FieldConstraints cannot be null", (Object[])new Object[0]);
    }

    public FieldExpression parse(String expression) {
        if (!StringUtils.containsAny((CharSequence)expression, (char[])this.specialCharsMinusStar)) {
            if ("*".equals(expression)) {
                return new Always(this.constraints);
            }
            this.constraints.validateAllCharsValid(expression);
            return this.parseOn(expression);
        }
        String[] array = expression.split(",");
        if (array.length > 1) {
            And and = new And();
            for (String exp : array) {
                and.and(this.parse(exp));
            }
            return and;
        }
        array = expression.split("-");
        if (array.length > 1) {
            return this.parseBetween(array);
        }
        String value = expression.split("/")[1];
        this.constraints.validateAllCharsValid(value);
        return new Every(this.constraints, new IntegerFieldValue(Integer.parseInt(value)));
    }

    private Between parseBetween(String[] array) {
        if (array[1].contains("/")) {
            String[] every = array[1].split("/");
            return new Between(this.constraints, this.map(this.constraints, array[0]), this.map(this.constraints, every[0]), this.mapToIntegerFieldValue(every[1]));
        }
        String from = array[0];
        String to = array[1];
        this.constraints.validateAllCharsValid(from);
        this.constraints.validateAllCharsValid(to);
        return new Between(this.constraints, this.map(this.constraints, from), this.map(this.constraints, to));
    }

    private On parseOn(String exp) {
        this.constraints.validateAllCharsValid(exp);
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.NONE);
        IntegerFieldValue nth = new IntegerFieldValue(-1);
        IntegerFieldValue time = new IntegerFieldValue(-1);
        String expression = exp;
        if (exp.contains("#")) {
            specialChar = new SpecialCharFieldValue(SpecialChar.HASH);
            String[] array = exp.split("#");
            nth = this.mapToIntegerFieldValue(array[1]);
            if (array[0].isEmpty()) {
                throw new IllegalArgumentException("Time should be specified!");
            }
            expression = array[0];
        }
        if (exp.contains("LW")) {
            specialChar = new SpecialCharFieldValue(SpecialChar.LW);
            expression = "".equals(exp = exp.replace("LW", "")) ? null : exp;
        }
        if (exp.contains("L")) {
            specialChar = new SpecialCharFieldValue(SpecialChar.L);
            expression = "".equals(exp = exp.replace("L", "")) ? null : exp;
        }
        if (exp.contains("W")) {
            specialChar = new SpecialCharFieldValue(SpecialChar.W);
            expression = exp.replace("W", "");
        }
        this.constraints.validateSpecialCharAllowed(specialChar.getValue());
        if (expression != null) {
            return new On(this.constraints, this.mapToIntegerFieldValue(expression), specialChar, nth);
        }
        return new On(this.constraints, time, specialChar, nth);
    }

    private IntegerFieldValue mapToIntegerFieldValue(String string) {
        this.constraints.validateAllCharsValid(string);
        try {
            return new IntegerFieldValue(Integer.parseInt(string));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid value. Expected some integer, found %s", string));
        }
    }

    private FieldValue map(FieldConstraints constraints, String string) {
        constraints.validateAllCharsValid(string);
        for (SpecialChar sc : SpecialChar.values()) {
            if (!sc.toString().equals(string)) continue;
            return new SpecialCharFieldValue(sc);
        }
        return new IntegerFieldValue(constraints.stringToInt(string));
    }
}

