/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.model.time.generator.EveryFieldValueGenerator;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

class BetweenFieldValueGenerator
extends FieldValueGenerator {
    public BetweenFieldValueGenerator(FieldExpression expression) {
        super(expression);
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        Between between = (Between)this.expression;
        int candidate = new EveryFieldValueGenerator(between.getEvery()).generateNextValue(reference);
        if (candidate > this.map(between.getTo())) {
            throw new NoSuchValueException();
        }
        return candidate;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        Between between = (Between)this.expression;
        int candidate = new EveryFieldValueGenerator(between.getEvery()).generatePreviousValue(reference);
        if (candidate < this.map(between.getFrom())) {
            throw new NoSuchValueException();
        }
        return candidate;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList values = Lists.newArrayList();
        Between between = (Between)this.expression;
        if (start <= this.map(between.getTo()) && this.map(between.getFrom()) <= end) {
            if (this.map(between.getTo()) < end) {
                end = this.map(between.getTo());
            }
            if (this.map(between.getFrom()) > start) {
                start = this.map(between.getFrom());
            }
            try {
                int reference = this.generateNextValue(start);
                while (reference < end) {
                    values.add(reference);
                    reference = this.generateNextValue(reference);
                }
            }
            catch (NoSuchValueException e) {
                // empty catch block
            }
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        Between between = (Between)this.expression;
        if (value >= this.map(between.getFrom()) && value <= this.map(between.getTo())) {
            return new EveryFieldValueGenerator(between.getEvery()).isMatch(value);
        }
        return false;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof Between;
    }

    private int map(FieldValue fieldValue) {
        if (fieldValue instanceof IntegerFieldValue) {
            return ((IntegerFieldValue)fieldValue).getValue();
        }
        throw new RuntimeException("Non integer values at intervals are not fully supported yet.");
    }
}

