/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time;

import com.cronutils.model.time.NearestValue;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.Validate;

class TimeNode {
    protected List<Integer> values;

    public TimeNode(List<Integer> values) {
        Validate.notEmpty(values, (String)"Values must not be empty", (Object[])new Object[0]);
        this.values = values;
        Collections.sort(this.values);
    }

    public NearestValue getNextValue(int reference, int shifts) {
        return this.getNearestValues(reference, shifts, new Function<Integer, Integer>(){

            public Integer apply(Integer integer) {
                return integer + 1;
            }
        });
    }

    public List<Integer> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public NearestValue getPreviousValue(int reference, int shifts) {
        return this.getNearestValues(reference, shifts, new Function<Integer, Integer>(){

            public Integer apply(Integer integer) {
                return integer - 1;
            }
        });
    }

    private NearestValue getNearestValues(int reference, int shiftsToApply, Function<Integer, Integer> indexTransform) {
        ArrayList<Integer> values = new ArrayList<Integer>(this.values);
        int index = 0;
        if (!values.contains(reference)) {
            for (Integer value : values) {
                if (value <= reference) continue;
                index = values.indexOf(value);
                break;
            }
        } else {
            index = values.indexOf(reference);
        }
        AtomicInteger shift = new AtomicInteger(0);
        int value = (Integer)values.get(index);
        for (int j = 0; j < shiftsToApply; ++j) {
            value = this.getValueFromList(values, (Integer)indexTransform.apply((Object)index), shift);
            index = values.indexOf(value);
        }
        return new NearestValue(value, shift.get());
    }

    private int getValueFromList(List<Integer> values, int index, AtomicInteger shift) {
        Validate.notEmpty(values, (String)"List must not be empty", (Object[])new Object[0]);
        if (index < 0) {
            shift.incrementAndGet();
            return this.getValueFromList(values, index += values.size(), shift);
        }
        if (index >= values.size()) {
            shift.incrementAndGet();
            return this.getValueFromList(values, index -= values.size(), shift);
        }
        return values.get(index);
    }
}

