/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field.constraint;

import com.cronutils.model.field.SpecialChar;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public class FieldConstraints {
    private Map<String, Integer> stringMapping;
    private Map<Integer, Integer> intMapping;
    private Set<SpecialChar> specialChars;
    private int startRange;
    private int endRange;
    private Pattern numsAndCharsPattern;
    private Pattern stringToIntKeysPattern;
    private Pattern lwPattern;

    public FieldConstraints(Map<String, Integer> stringMapping, Map<Integer, Integer> intMapping, Set<SpecialChar> specialChars, int startRange, int endRange) {
        this.stringMapping = Collections.unmodifiableMap((Map)Validate.notNull(stringMapping, (String)"String mapping must not be null", (Object[])new Object[0]));
        this.intMapping = Collections.unmodifiableMap((Map)Validate.notNull(intMapping, (String)"Integer mapping must not be null", (Object[])new Object[0]));
        this.specialChars = Collections.unmodifiableSet((Set)Validate.notNull(specialChars, (String)"Special (non-standard) chars set must not be null", (Object[])new Object[0]));
        this.startRange = startRange;
        this.endRange = endRange;
        this.lwPattern = this.buildLWPattern(this.specialChars);
        this.stringToIntKeysPattern = this.buildStringToIntPattern(stringMapping.keySet());
        this.numsAndCharsPattern = Pattern.compile("[#\\?/\\*0-9]");
    }

    public int stringToInt(String exp) {
        if (this.stringMapping.containsKey(exp)) {
            return this.stringMapping.get(exp);
        }
        try {
            return Integer.parseInt(exp);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public int intToInt(Integer exp) {
        if (this.intMapping.containsKey(exp)) {
            return this.intMapping.get(exp);
        }
        return exp;
    }

    public int validateInRange(int number) {
        if (this.isInRange(number)) {
            return number;
        }
        throw new IllegalArgumentException(String.format("Number %s out of range [%s,%s]", number, this.startRange, this.endRange));
    }

    public boolean isInRange(int number) {
        return number >= this.startRange && number <= this.endRange;
    }

    public void validateSpecialCharAllowed(SpecialChar specialChar) {
        if (!this.isSpecialCharAllowed(specialChar)) {
            throw new IllegalArgumentException(String.format("Special char %s not supported!", new Object[]{specialChar}));
        }
    }

    public boolean isSpecialCharAllowed(SpecialChar specialChar) {
        return this.specialChars.contains((Object)specialChar);
    }

    public boolean areAllCharsValid(String exp) {
        return this.removeValidChars(exp).isEmpty();
    }

    public void validateAllCharsValid(String exp) {
        String invalidChars = this.removeValidChars(exp);
        if (!invalidChars.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid chars in expression! Expression: %s Invalid chars: %s", exp, invalidChars));
        }
    }

    String removeValidChars(String exp) {
        Matcher numsAndCharsMatcher = this.numsAndCharsPattern.matcher(exp);
        Matcher stringToIntKeysMatcher = this.stringToIntKeysPattern.matcher(numsAndCharsMatcher.replaceAll(""));
        Matcher specialWordsMatcher = this.lwPattern.matcher(stringToIntKeysMatcher.replaceAll(""));
        return specialWordsMatcher.replaceAll("").replaceAll("\\s+", "");
    }

    Pattern buildLWPattern(Set<SpecialChar> specialChars) {
        HashSet scs = Sets.newHashSet();
        for (SpecialChar sc : new SpecialChar[]{SpecialChar.L, SpecialChar.LW, SpecialChar.W}) {
            if (!specialChars.contains((Object)sc)) continue;
            scs.add(sc.name());
        }
        return this.buildWordsPattern(scs);
    }

    Pattern buildStringToIntPattern(Set<String> strings) {
        return this.buildWordsPattern(strings);
    }

    Pattern buildWordsPattern(Set<String> words) {
        StringBuilder builder = new StringBuilder("\\b(");
        boolean first = true;
        for (String word : words) {
            if (!first) {
                builder.append("|");
            } else {
                first = false;
            }
            builder.append(word);
        }
        builder.append(")\\b");
        return Pattern.compile(builder.toString());
    }
}

