/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.mapper.format;

import com.cronutils.mapper.format.DateTimeFormatLocaleStrategy;
import com.cronutils.mapper.format.MDYDateTimeFormatLocaleStrategy;
import java.util.Locale;
import org.apache.commons.lang3.Validate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeFormatBuilder {
    private Locale locale = Locale.US;

    DateTimeFormatBuilder() {
    }

    public DateTimeFormatBuilder usingLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public DateTimeFormatter createPatternFor(String expression) {
        DateTimeFormatLocaleStrategy localeStrategy = this.createLocaleStrategyInstance();
        Validate.notBlank((CharSequence)expression);
        expression = expression.replaceAll("\\s+", " ");
        expression = expression.replace(" AM", "AM").replace(" am", "am").replace(" PM", "PM").replace(" pm", "pm");
        String[] parts = expression.split(" ");
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            builder.append(String.format("%s ", localeStrategy.retrievePattern(part)));
        }
        return DateTimeFormat.forPattern((String)builder.toString().trim());
    }

    private DateTimeFormatLocaleStrategy createLocaleStrategyInstance() {
        return new MDYDateTimeFormatLocaleStrategy();
    }
}

