/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.model.field.Every;
import com.cronutils.model.field.FieldExpression;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

class EveryFieldValueGenerator
extends FieldValueGenerator {
    public EveryFieldValueGenerator(FieldExpression expression) {
        super(expression);
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        Every every = (Every)this.expression;
        int period = every.getTime();
        int remainder = reference % period;
        return reference + (period - remainder);
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        Every every = (Every)this.expression;
        int period = every.getTime();
        int remainder = reference % period;
        if (remainder == 0) {
            return reference - period;
        }
        return reference - remainder;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList values = Lists.newArrayList();
        try {
            int reference = this.generateNextValue(start);
            while (reference < end) {
                values.add(reference);
                reference = this.generateNextValue(reference);
            }
        }
        catch (NoSuchValueException e) {
            e.printStackTrace();
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        Every every = (Every)this.expression;
        return value % every.getTime() == 0;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof Every;
    }
}

