/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time;

import com.cronutils.mapper.WeekDay;
import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import com.cronutils.model.time.ExecutionTimeBuilder;
import com.cronutils.model.time.NearestValue;
import com.cronutils.model.time.TimeNode;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.FieldValueGeneratorFactory;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class ExecutionTime {
    private CronDefinition cronDefinition;
    private FieldValueGenerator yearsValueGenerator;
    private CronField daysOfWeekCronField;
    private CronField daysOfMonthCronField;
    private TimeNode months;
    private TimeNode hours;
    private TimeNode minutes;
    private TimeNode seconds;

    @VisibleForTesting
    ExecutionTime(CronDefinition cronDefinition, FieldValueGenerator yearsValueGenerator, CronField daysOfWeekCronField, CronField daysOfMonthCronField, TimeNode months, TimeNode hours, TimeNode minutes, TimeNode seconds) {
        this.cronDefinition = (CronDefinition)Validate.notNull((Object)cronDefinition);
        this.yearsValueGenerator = (FieldValueGenerator)Validate.notNull((Object)yearsValueGenerator);
        this.daysOfWeekCronField = (CronField)Validate.notNull((Object)daysOfWeekCronField);
        this.daysOfMonthCronField = (CronField)Validate.notNull((Object)daysOfMonthCronField);
        this.months = (TimeNode)Validate.notNull((Object)months);
        this.hours = (TimeNode)Validate.notNull((Object)hours);
        this.minutes = (TimeNode)Validate.notNull((Object)minutes);
        this.seconds = (TimeNode)Validate.notNull((Object)seconds);
    }

    public static ExecutionTime forCron(Cron cron) {
        Map<CronFieldName, CronField> fields = cron.retrieveFieldsAsMap();
        ExecutionTimeBuilder executionTimeBuilder = new ExecutionTimeBuilder(cron.getCronDefinition());
        if (fields.containsKey((Object)CronFieldName.SECOND)) {
            executionTimeBuilder.forSecondsMatching(fields.get((Object)CronFieldName.SECOND));
        }
        executionTimeBuilder.forMinutesMatching(fields.get((Object)CronFieldName.MINUTE)).forHoursMatching(fields.get((Object)CronFieldName.HOUR)).forDaysOfMonthMatching(fields.get((Object)CronFieldName.DAY_OF_MONTH)).forDaysOfWeekMatching(fields.get((Object)CronFieldName.DAY_OF_WEEK)).forMonthsMatching(fields.get((Object)CronFieldName.MONTH));
        if (fields.containsKey((Object)CronFieldName.YEAR)) {
            executionTimeBuilder.forYearsMatching(fields.get((Object)CronFieldName.YEAR));
        }
        return executionTimeBuilder.build();
    }

    public DateTime nextExecution(DateTime date) {
        NearestValue monthsValue;
        Validate.notNull((Object)date);
        NearestValue secondsValue = this.seconds.getNextValue(date.getSecondOfMinute(), 1);
        NearestValue minutesValue = this.minutes.getNextValue(date.getMinuteOfHour(), secondsValue.getShifts());
        NearestValue hoursValue = this.hours.getNextValue(date.getHourOfDay(), minutesValue.getShifts());
        int month = 1;
        int day = 1;
        if (this.months.getValues().contains(date.getMonthOfYear())) {
            monthsValue = new NearestValue(date.getMonthOfYear(), 0);
            month = monthsValue.getValue();
            day = date.getDayOfMonth();
        } else {
            monthsValue = this.months.getNextValue(date.getMonthOfYear(), 0);
            month = monthsValue.getValue();
            day = 1;
        }
        TimeNode days = new TimeNode(this.generateDayCandidates(date.getYear(), month, ((DayOfWeekFieldDefinition)this.cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()));
        NearestValue daysValue = days.getNextValue(day, hoursValue.getShifts());
        monthsValue = this.months.getNextValue(month, daysValue.getShifts());
        if (daysValue.getShifts() > 0) {
            days = new TimeNode(this.generateDayCandidates(date.getYear(), monthsValue.getValue(), ((DayOfWeekFieldDefinition)this.cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()));
            daysValue = new NearestValue(days.getValues().get(0), 0);
        }
        NearestValue yearsValue = new TimeNode(this.generateYearCandidates(date.getYear())).getNextValue(date.getYear(), monthsValue.getShifts());
        return new DateTime(yearsValue.getValue(), monthsValue.getValue(), daysValue.getValue(), hoursValue.getValue(), minutesValue.getValue(), secondsValue.getValue());
    }

    public Duration timeToNextExecution(DateTime date) {
        return new Interval((ReadableInstant)date, (ReadableInstant)this.nextExecution(date)).toDuration();
    }

    public DateTime lastExecution(DateTime date) {
        NearestValue monthsValue;
        Validate.notNull((Object)date);
        NearestValue secondsValue = this.seconds.getPreviousValue(date.getSecondOfMinute(), 1);
        NearestValue minutesValue = this.minutes.getPreviousValue(date.getMinuteOfHour(), secondsValue.getShifts());
        NearestValue hoursValue = this.hours.getPreviousValue(date.getHourOfDay(), minutesValue.getShifts());
        int month = 1;
        int day = 1;
        if (this.months.getValues().contains(date.getMonthOfYear())) {
            monthsValue = new NearestValue(date.getMonthOfYear(), 0);
            month = monthsValue.getValue();
            day = date.getDayOfMonth();
        } else {
            monthsValue = this.months.getPreviousValue(date.getMonthOfYear(), 0);
            month = monthsValue.getValue();
            day = new DateTime(date.getYear(), month, 1, 1, 1).dayOfMonth().withMaximumValue().getDayOfMonth();
        }
        TimeNode days = new TimeNode(this.generateDayCandidates(date.getYear(), month, ((DayOfWeekFieldDefinition)this.cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()));
        NearestValue daysValue = days.getPreviousValue(day, hoursValue.getShifts());
        monthsValue = this.months.getPreviousValue(month, daysValue.getShifts());
        if (daysValue.getShifts() > 0) {
            days = new TimeNode(this.generateDayCandidates(date.getYear(), monthsValue.getValue(), ((DayOfWeekFieldDefinition)this.cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()));
            List<Integer> dayCandidates = days.getValues();
            daysValue = new NearestValue(dayCandidates.get(dayCandidates.size() - 1), 0);
        }
        NearestValue yearsValue = new TimeNode(this.generateYearCandidates(date.getYear())).getPreviousValue(date.getYear(), monthsValue.getShifts());
        return new DateTime(yearsValue.getValue(), monthsValue.getValue(), daysValue.getValue(), hoursValue.getValue(), minutesValue.getValue(), secondsValue.getValue());
    }

    public Duration timeFromLastExecution(DateTime date) {
        return new Interval((ReadableInstant)this.lastExecution(date), (ReadableInstant)date).toDuration();
    }

    private List<Integer> generateDayCandidates(int year, int month, WeekDay mondayDoWValue) {
        DateTime date = new DateTime(year, month, 1, 1, 1);
        ArrayList candidates = Lists.newArrayList();
        candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, date.dayOfMonth().getMaximumValue()));
        candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, date.dayOfMonth().getMaximumValue()));
        return candidates;
    }

    private List<Integer> generateYearCandidates(int referenceYear) {
        ArrayList candidates = Lists.newArrayList();
        if (this.yearsValueGenerator.isMatch(referenceYear)) {
            candidates.add(referenceYear);
        }
        int highReference = referenceYear;
        int lowReference = referenceYear;
        for (int j = 0; j < 5; ++j) {
            try {
                highReference = this.yearsValueGenerator.generateNextValue(highReference);
                lowReference = this.yearsValueGenerator.generatePreviousValue(lowReference);
                candidates.add(highReference);
                candidates.add(lowReference);
                continue;
            }
            catch (NoSuchValueException e) {
                // empty catch block
            }
        }
        return candidates;
    }
}

