/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events;

import com.criteo.events.CRTOLog;
import com.criteo.events.Event;
import com.criteo.events.ExtraData;
import com.criteo.events.product.BasketProduct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class TransactionConfirmationEvent
extends Event {
    private CopyOnWriteArrayList<BasketProduct> basketProductList = new CopyOnWriteArrayList();
    private AtomicReference<String> transactionId = new AtomicReference();
    private AtomicReference<Currency> currency = new AtomicReference();
    private AtomicBoolean newCustomer = new AtomicBoolean();

    public TransactionConfirmationEvent(String transactionId, Iterable<BasketProduct> basketProducts) {
        this.setTransactionId(transactionId);
        this.setBasketProductList(basketProducts);
    }

    public TransactionConfirmationEvent(String transactionId, BasketProduct ... basketProducts) {
        this.setTransactionId(transactionId);
        this.setBasketProductList(new ArrayList<BasketProduct>(Arrays.asList(basketProducts)));
    }

    public TransactionConfirmationEvent(String transactionId, Iterable<BasketProduct> basketProducts, GregorianCalendar startDate, GregorianCalendar endDate) {
        this.setTransactionId(transactionId);
        this.setBasketProductList(basketProducts);
        this.setStartDate(startDate);
        this.setEndDate(endDate);
    }

    public TransactionConfirmationEvent(TransactionConfirmationEvent event) {
        super(event);
        this.setTransactionId(event.transactionId.get());
        this.setBasketProductList(event.basketProductList);
        this.setCurrency(event.currency.get());
    }

    public void addBasketProduct(BasketProduct basketProduct) {
        if (basketProduct == null) {
            CRTOLog.e("Argument basketProduct must not be null");
            return;
        }
        this.basketProductList.add(basketProduct);
    }

    public CopyOnWriteArrayList<BasketProduct> getBasketProductList() {
        return this.basketProductList;
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            CRTOLog.e("Argument currency must not be null");
            return;
        }
        this.currency.set(currency);
    }

    public Currency getCurrency() {
        return this.currency.get();
    }

    public void setDeduplication(boolean deduplication) {
        this.extraDataMap.put("deduplication", new ExtraData(deduplication ? 1 : 0));
    }

    public boolean getDeduplication() {
        ExtraData extraData = (ExtraData)this.extraDataMap.get("deduplication");
        return extraData != null ? extraData.getIntValue() != 0 : false;
    }

    public void setNewCustomer(boolean newCustomer) {
        this.extraDataMap.put("new_customer", new ExtraData(newCustomer ? 1 : 0));
    }

    public boolean getNewCustomer() {
        ExtraData extraData = (ExtraData)this.extraDataMap.get("new_customer");
        return extraData != null ? extraData.getIntValue() != 0 : false;
    }

    public void setTransactionId(String transactionId) {
        if (transactionId == null) {
            CRTOLog.e("Argument transactionId must not be null");
            return;
        }
        this.transactionId.set(transactionId);
    }

    public String getTransactionId() {
        return this.transactionId.get();
    }

    private CopyOnWriteArrayList<BasketProduct> makeBasketProducts(Iterable<BasketProduct> basketProductIterable) {
        CopyOnWriteArrayList<BasketProduct> basketProducts = new CopyOnWriteArrayList<BasketProduct>();
        for (BasketProduct product : basketProductIterable) {
            basketProducts.add(new BasketProduct(product.getProductId(), product.getPrice(), product.getQuantity()));
        }
        return basketProducts;
    }

    public void setBasketProductList(Iterable<BasketProduct> basketProductList) {
        if (basketProductList == null) {
            CRTOLog.e("Argument basketProductList must not be null");
            return;
        }
        this.basketProductList = this.makeBasketProducts(basketProductList);
    }

    @Override
    public GregorianCalendar getStartDate() {
        return super.getStartDate();
    }

    @Override
    public GregorianCalendar getEndDate() {
        return super.getEndDate();
    }

    @Override
    public void setStartDate(GregorianCalendar startDate) {
        super.setStartDate(startDate);
    }

    @Override
    public void setEndDate(GregorianCalendar endDate) {
        super.setEndDate(endDate);
    }
}

