/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events;

import android.content.Context;
import android.util.Patterns;
import com.criteo.events.AppLaunchEvent;
import com.criteo.events.BasketViewEvent;
import com.criteo.events.CRTOLog;
import com.criteo.events.DataEvent;
import com.criteo.events.DeeplinkEvent;
import com.criteo.events.DeviceInfo;
import com.criteo.events.EmailHasher;
import com.criteo.events.EventSenderService;
import com.criteo.events.HomeViewEvent;
import com.criteo.events.JSONSerializer;
import com.criteo.events.ProductListViewEvent;
import com.criteo.events.ProductViewEvent;
import com.criteo.events.TransactionConfirmationEvent;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class EventService {
    private String country;
    private String language;
    private String customerId;
    private String email;
    private String accountName;
    private Executor executor;
    private JSONSerializer jsonSerializer = new JSONSerializer();
    static String sharedPrefs = "CriteoTracker";
    static Context context;

    public EventService(Context context) {
        EventService.context = context;
        this.country = EventService.getDefaultCountry();
        this.language = EventService.getDefaultLanguage();
        this.accountName = EventService.getDefaultAccountName();
        this.executor = Executors.newSingleThreadExecutor();
    }

    public EventService(Context context, String country, String language) {
        EventService.context = context;
        this.country = country;
        this.language = language;
    }

    public EventService(Context context, String country, String language, String customerId) {
        EventService.context = context;
        this.country = country;
        this.language = language;
        this.customerId = customerId;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.setEmail(email, EmailType.CLEARTEXT);
    }

    public void setEmail(String email, EmailType type) {
        switch (type) {
            case CLEARTEXT: {
                Pattern emailPattern = Patterns.EMAIL_ADDRESS;
                if (email == null || !emailPattern.matcher(email).matches()) {
                    CRTOLog.e("Argument email is not a valid email address");
                    return;
                }
                this.email = EmailHasher.computeMd5Hash(email);
                break;
            }
            case HASHED_MD5: {
                this.email = email;
                break;
            }
            default: {
                CRTOLog.e("Argument type is not a valid email type");
            }
        }
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        if (EventService.isCountryValid(country)) {
            this.country = country;
        } else {
            CRTOLog.e("Argument country must be valid ISO 3166-1 two-letter code");
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        if (EventService.isLanguageValid(language)) {
            this.language = language;
        } else {
            CRTOLog.e("Argument language must be valid ISO 639-1 two-letter code");
        }
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        if (customerId == null) {
            CRTOLog.e("Argument customerId must not be null");
            return;
        }
        this.customerId = customerId;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void send(AppLaunchEvent event) {
        event.setTimestamp(new Date());
        this.sendSerializedEvent(this.jsonSerializer.serializeToJSON(event), event.getTimestamp().getTime());
    }

    public void send(BasketViewEvent event) {
        event.setTimestamp(new Date());
        this.sendSerializedEvent(this.jsonSerializer.serializeToJSON(event), event.getTimestamp().getTime());
    }

    public void send(HomeViewEvent event) {
        event.setTimestamp(new Date());
        this.sendSerializedEvent(this.jsonSerializer.serializeToJSON(event), event.getTimestamp().getTime());
    }

    public void send(ProductListViewEvent event) {
        event.setTimestamp(new Date());
        this.sendSerializedEvent(this.jsonSerializer.serializeToJSON(event), event.getTimestamp().getTime());
    }

    public void send(ProductViewEvent event) {
        event.setTimestamp(new Date());
        this.sendSerializedEvent(this.jsonSerializer.serializeToJSON(event), event.getTimestamp().getTime());
    }

    public void send(TransactionConfirmationEvent event) {
        event.setTimestamp(new Date());
        this.sendSerializedEvent(this.jsonSerializer.serializeToJSON(event), event.getTimestamp().getTime());
    }

    public void send(DataEvent event) {
        event.setTimestamp(new Date());
        this.sendSerializedEvent(this.jsonSerializer.serializeToJSON(event), event.getTimestamp().getTime());
    }

    public void send(DeeplinkEvent event) {
        event.setTimestamp(new Date());
        this.sendSerializedEvent(this.jsonSerializer.serializeToJSON(event), event.getTimestamp().getTime());
    }

    private static String getDefaultCountry() {
        return DeviceInfo.getCountry();
    }

    private static String getDefaultLanguage() {
        return DeviceInfo.getLanguage();
    }

    private static String getDefaultAccountName() {
        return DeviceInfo.getBundleName();
    }

    private static boolean isCountryValid(String country) {
        boolean valid = false;
        if (Arrays.asList(DeviceInfo.getCountriesList()).contains(country)) {
            valid = true;
        }
        return valid;
    }

    private static boolean isLanguageValid(String language) {
        boolean valid = false;
        if (Arrays.asList(DeviceInfo.getLanguageList()).contains(language)) {
            valid = true;
        }
        return valid;
    }

    private void sendSerializedEvent(JSONObject serializedEvent, long eventTimestamp) {
        if (serializedEvent == null) {
            return;
        }
        this.executor.execute(new AsyncEventHandler(serializedEvent, eventTimestamp));
    }

    public static enum EmailType {
        CLEARTEXT,
        HASHED_MD5;

    }

    private class AsyncEventHandler
    implements Runnable {
        private JSONObject serializedEvent;
        private long eventTimestamp;

        private AsyncEventHandler(JSONObject serializedEvent, long eventTimestamp) {
            this.serializedEvent = serializedEvent;
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public void run() {
            try {
                JSONObject payload = JSONSerializer.commonPayload(EventService.this);
                JSONSerializer.setPayloadEvent(payload, this.serializedEvent);
                EventSenderService.sendEvent(payload.toString(), this.eventTimestamp, context);
            }
            catch (JSONException e) {
                CRTOLog.e("Error in JSON serialisation", e);
            }
        }
    }
}

