/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events;

import com.criteo.events.CRTOLog;
import com.criteo.events.Event;
import com.criteo.events.product.Product;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.concurrent.atomic.AtomicReference;

public class ProductViewEvent
extends Event {
    private AtomicReference<Product> product = new AtomicReference();
    private AtomicReference<Currency> currency = new AtomicReference();

    public ProductViewEvent(String productId, double price) {
        this.product.set(new Product(productId, price));
    }

    public ProductViewEvent(Product product) {
        this.product.set(product);
    }

    public ProductViewEvent(Product product, Currency currency, GregorianCalendar startDate, GregorianCalendar endDate) {
        this.product.set(product);
        this.setStartDate(startDate);
        this.setEndDate(endDate);
        this.setCurrency(currency);
    }

    public ProductViewEvent(ProductViewEvent event) {
        super(event);
        this.setProduct(event.product.get());
        this.setCurrency(this.currency.get());
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            CRTOLog.e("Argument currency must not be null");
            return;
        }
        this.currency.set(currency);
    }

    public Currency getCurrency() {
        return this.currency.get();
    }

    public Product getProduct() {
        return this.product.get();
    }

    public void setProduct(Product product) {
        if (product == null) {
            CRTOLog.e("Argument product must not be null");
            return;
        }
        this.product.set(product);
    }

    @Override
    public GregorianCalendar getStartDate() {
        return super.getStartDate();
    }

    @Override
    public GregorianCalendar getEndDate() {
        return super.getEndDate();
    }

    @Override
    public void setStartDate(GregorianCalendar startDate) {
        super.setStartDate(startDate);
    }

    @Override
    public void setEndDate(GregorianCalendar endDate) {
        super.setEndDate(endDate);
    }
}

