/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.VisibleForTesting;
import com.criteo.events.EventPoster;
import com.criteo.events.EventPosterFactory;
import com.criteo.events.EventQueue;
import com.criteo.events.SendPolicy;
import java.util.Deque;

public class EventSenderService
extends IntentService {
    static final String ACTION_SEND_EVENT = "com.criteo.event.intent.action.SEND_EVENT";
    @VisibleForTesting
    static EventPosterFactory eventPosterFactory = new EventPosterFactory();
    protected final Deque<Intent> eventQueue = EventQueue.INSTANCE.get();

    public EventSenderService() {
        super("EventSenderService");
        this.setIntentRedelivery(true);
    }

    protected void onHandleIntent(Intent eventIntent) {
        if (eventIntent != null) {
            this.eventQueue.add(eventIntent);
        }
        this.postWaitingIntents();
    }

    private void postWaitingIntents() {
        boolean stop = false;
        while (!stop && !this.eventQueue.isEmpty()) {
            Intent eventIntent = this.eventQueue.remove();
            stop = !this.postIntent(eventIntent);
        }
    }

    private boolean postIntent(Intent eventIntent) {
        int eventTries;
        if (!eventIntent.getAction().equals(ACTION_SEND_EVENT)) {
            return true;
        }
        EventPoster eventPoster = eventPosterFactory.createEventPoster();
        SendPolicy sendPolicy = eventPoster.getSendPolicy();
        if (!sendPolicy.canRetry(eventTries = eventIntent.getIntExtra("retries", 0))) {
            return true;
        }
        int size = this.eventQueue.size();
        if (sendPolicy.isQueueFull(size)) {
            return true;
        }
        String eventPayload = eventIntent.getStringExtra("payload");
        if (eventPayload == null || eventPayload.isEmpty()) {
            return true;
        }
        long eventTimestamp = eventIntent.getLongExtra("timestamp", 0L);
        int tries = 0;
        while (sendPolicy.canRetryRedirect(tries)) {
            if (sendPolicy.isEventExpired(eventTimestamp)) {
                return true;
            }
            EventPoster.PostResult result = eventPoster.post(eventPayload);
            switch (result) {
                case DONE: {
                    return true;
                }
                case RETRY_LATER: {
                    eventIntent.putExtra("retries", eventIntent.getIntExtra("retries", 0) + 1);
                    this.eventQueue.offerFirst(eventIntent);
                    return false;
                }
            }
            ++tries;
        }
        return true;
    }

    static void sendEvent(String eventPayload, long eventTimestamp, Context context) {
        Intent intent = new Intent(context, EventSenderService.class);
        intent.setAction(ACTION_SEND_EVENT);
        intent.putExtra("payload", eventPayload);
        intent.putExtra("timestamp", eventTimestamp);
        intent.putExtra("retries", 0);
        context.startService(intent);
    }
}

