/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events;

import java.util.Date;

class SendPolicy {
    static final long DEFAULT_MAX_QUEUE_SIZE = 15L;
    static final long DEFAULT_VALIDITY_DURATION = 3600000L;
    static final long DEFAULT_MAX_ATTEMPTS = 3L;
    static final long DEFAULT_MAX_REDIRECT_ATTEMPTS = 3L;
    private final long maxQueueSize;
    private final long validityDuration;
    private final long maxAttempts;
    private final long maxRedirectAttempts;

    public SendPolicy() {
        this(15L, 3600000L, 3L, 3L);
    }

    public SendPolicy(long maxQueueSize, long validityDuration, long maxAttempts, long maxRedirectAttempts) {
        this.maxQueueSize = maxQueueSize;
        this.validityDuration = validityDuration;
        this.maxAttempts = maxAttempts;
        this.maxRedirectAttempts = maxRedirectAttempts;
    }

    public boolean isQueueFull(int queueSize) {
        return (long)queueSize >= this.maxQueueSize;
    }

    public boolean isEventExpired(long eventTimestamp) {
        boolean expired = false;
        if (new Date().getTime() - eventTimestamp > this.validityDuration) {
            expired = true;
        }
        return expired;
    }

    public boolean canRetry(int attempts) {
        return (long)attempts < this.maxAttempts;
    }

    public boolean canRetryRedirect(int attempts) {
        return (long)attempts < this.maxRedirectAttempts;
    }
}

