/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events;

import com.criteo.events.CRTOLog;
import com.criteo.events.Event;
import com.criteo.events.product.Product;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

public class ProductListViewEvent
extends Event {
    private CopyOnWriteArrayList<Product> productList = new CopyOnWriteArrayList();
    private AtomicReference<Currency> currency = new AtomicReference();

    public ProductListViewEvent(Iterable<Product> productList) {
        this.setProductList(productList);
    }

    public ProductListViewEvent(Product ... products) {
        this.setProductList(new ArrayList<Product>(Arrays.asList(products)));
    }

    public ProductListViewEvent(Iterable<Product> productList, Currency currency, GregorianCalendar startDate, GregorianCalendar endDate) {
        this.setProductList(productList);
        this.setStartDate(startDate);
        this.setEndDate(endDate);
        this.setCurrency(currency);
    }

    public ProductListViewEvent(ProductListViewEvent event) {
        super(event);
        this.setProductList(event.productList);
        this.setCurrency(event.currency.get());
    }

    public void setCurrency(Currency currency) {
        if (currency == null) {
            CRTOLog.e("Argument currency must not be null");
            return;
        }
        this.currency.set(currency);
    }

    public Currency getCurrency() {
        return this.currency.get();
    }

    public CopyOnWriteArrayList<Product> getProductList() {
        return this.productList;
    }

    private CopyOnWriteArrayList<Product> makeProducts(Iterable<Product> catalogProducts) {
        CopyOnWriteArrayList<Product> catalogProductList = new CopyOnWriteArrayList<Product>();
        for (Product product : catalogProducts) {
            catalogProductList.add(new Product(product.getProductId(), product.getPrice()));
        }
        return catalogProductList;
    }

    public void setProductList(Iterable<Product> productList) {
        if (productList == null) {
            CRTOLog.e("Argument productList must not be null");
            return;
        }
        this.productList = this.makeProducts(productList);
    }

    @Override
    public GregorianCalendar getStartDate() {
        return super.getStartDate();
    }

    @Override
    public GregorianCalendar getEndDate() {
        return super.getEndDate();
    }

    @Override
    public void setStartDate(GregorianCalendar startDate) {
        super.setStartDate(startDate);
    }

    @Override
    public void setEndDate(GregorianCalendar endDate) {
        super.setEndDate(endDate);
    }
}

