/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events;

import com.criteo.events.CRTOLog;
import java.util.GregorianCalendar;

class ExtraData {
    private ExtraDataType valueType;
    private float floatValue;
    private int intValue;
    private GregorianCalendar dateValue;
    private String stringValue;

    public ExtraData(float value) {
        this.valueType = ExtraDataType.Float;
        this.floatValue = value;
    }

    public ExtraData(int value) {
        this.valueType = ExtraDataType.Int;
        this.intValue = value;
    }

    public ExtraData(GregorianCalendar value) {
        this.valueType = ExtraDataType.Date;
        this.dateValue = value;
    }

    public ExtraData(String value) {
        this.valueType = ExtraDataType.String;
        this.stringValue = value;
    }

    ExtraDataType getType() {
        return this.valueType;
    }

    Object getValue() {
        switch (this.valueType) {
            case Float: {
                return Float.valueOf(this.getFloatValue());
            }
            case Int: {
                return this.getIntValue();
            }
            case Date: {
                return this.getDateValue();
            }
            case String: {
                return this.getStringValue();
            }
        }
        return null;
    }

    public float getFloatValue() {
        if (this.valueType != ExtraDataType.Float) {
            String error = String.format("Attempt to retrieve float value from %s ExtraData instance", new Object[]{this.valueType});
            CRTOLog.e(error);
            return 0.0f;
        }
        return this.floatValue;
    }

    public int getIntValue() {
        if (this.valueType != ExtraDataType.Int) {
            String error = String.format("Attempt to retrieve int value from %s ExtraData instance", new Object[]{this.valueType});
            CRTOLog.e(error);
            return 0;
        }
        return this.intValue;
    }

    public GregorianCalendar getDateValue() {
        if (this.valueType != ExtraDataType.Date) {
            String error = String.format("Attempt to retrieve Date value from %s ExtraData instance", new Object[]{this.valueType});
            CRTOLog.e(error);
            return null;
        }
        return this.dateValue;
    }

    public String getStringValue() {
        if (this.valueType != ExtraDataType.String) {
            String error = String.format("Attempt to retrieve String value from %s ExtraData instance", new Object[]{this.valueType});
            CRTOLog.e(error);
            return null;
        }
        return this.stringValue;
    }

    static enum ExtraDataType {
        Float,
        Date,
        Int,
        String;

    }
}

