/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events;

import com.criteo.events.CRTOLog;
import com.criteo.events.EventKeys;
import com.criteo.events.ExtraData;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Event {
    static final int NO_USER_SEGMENT = 0;
    ConcurrentHashMap<String, ExtraData> extraDataMap = new ConcurrentHashMap();
    private Date timestamp = new Date();

    Event() {
    }

    Event(Event event) {
        this.extraDataMap = new ConcurrentHashMap<String, ExtraData>(event.extraDataMap);
        this.setTimestamp(event.getTimestamp());
    }

    protected GregorianCalendar getStartDate() {
        ExtraData value = this.extraDataMap.get("checkin_date");
        return value.getDateValue();
    }

    protected GregorianCalendar getEndDate() {
        ExtraData value = this.extraDataMap.get("checkout_date");
        return value.getDateValue();
    }

    protected void setStartDate(GregorianCalendar startDate) {
        if (startDate == null) {
            CRTOLog.e("The startDate and endDate arguments must not be null");
            return;
        }
        this.extraDataMap.put("checkin_date", new ExtraData(startDate));
    }

    protected void setEndDate(GregorianCalendar endDate) {
        if (endDate == null) {
            CRTOLog.e("The startDate and endDate arguments must not be null");
            return;
        }
        this.extraDataMap.put("checkout_date", new ExtraData(endDate));
    }

    public void setUserSegment(int segment) {
        this.extraDataMap.put("user_segment", new ExtraData(segment));
    }

    public int getUserSegment() {
        ExtraData value = this.extraDataMap.get("user_segment");
        return value != null ? value.getIntValue() : 0;
    }

    public Event addExtraData(String key, float value) {
        this.putExtraData(key, new ExtraData(value));
        return this;
    }

    public Event addExtraData(String key, GregorianCalendar value) {
        this.putExtraData(key, new ExtraData(value));
        return this;
    }

    public Event addExtraData(String key, int value) {
        this.putExtraData(key, new ExtraData(value));
        return this;
    }

    public Event addExtraData(String key, String value) {
        this.putExtraData(key, new ExtraData(value));
        return this;
    }

    private void putExtraData(String key, ExtraData value) {
        if (EventKeys.isKeyReserved(key)) {
            String error = String.format("The key argument %s must not be a reserved EventKey value.", key);
            CRTOLog.e(error);
            return;
        }
        this.extraDataMap.put(key, value);
    }

    protected void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    protected Date getTimestamp() {
        return this.timestamp;
    }

    ExtraData getExtraData(String key) {
        return this.extraDataMap.get(key);
    }

    public float getFloatExtraData(String key) {
        ExtraData value = this.extraDataMap.get(key);
        return value.getFloatValue();
    }

    public int getIntExtraData(String key) {
        ExtraData value = this.extraDataMap.get(key);
        return value.getIntValue();
    }

    public GregorianCalendar getDateExtraData(String key) {
        ExtraData value = this.extraDataMap.get(key);
        return value.getDateValue();
    }

    public String getStringExtraData(String key) {
        ExtraData value = this.extraDataMap.get(key);
        return value.getStringValue();
    }

    Map<String, ExtraData> getExtraDataMap() {
        return new ConcurrentHashMap<String, ExtraData>(this.extraDataMap);
    }

    public String extraDatatoString() {
        return this.extraDataMap.toString();
    }
}

