/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events;

import android.support.annotation.Nullable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class EmailHasher {
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    EmailHasher() {
    }

    @Nullable
    public static String computeMd5Hash(@Nullable String email) {
        if (email == null) {
            return null;
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] emailBuffer = EmailHasher.getCanonicalEmail(email).getBytes();
            byte[] hash = md5.digest(emailBuffer);
            return EmailHasher.bytesToHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    private static String getCanonicalEmail(String email) {
        return email.toLowerCase().trim();
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

