/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import com.criteo.events.AdvertisingInfo;
import com.criteo.events.CRTOLog;
import com.criteo.events.EventService;
import java.lang.reflect.Method;

class AdvertisingInfoLoader {
    private static final String AdvertisingIdClientClassName = "com.google.android.gms.ads.identifier.AdvertisingIdClient";

    AdvertisingInfoLoader() {
    }

    public static AdvertisingInfo getAdvertisingInfo() {
        try {
            ApplicationInfo ai = EventService.context.getPackageManager().getApplicationInfo(EventService.context.getPackageName(), 128);
            if (ai.metaData.getInt("com.google.android.gms.version") == 0) {
                CRTOLog.e("You must include and then set the com.google.android.gms.version value in the AndroidManifest.xml file in order to use the GAID");
                return null;
            }
            Class<?> AdvertisingIdClient = Class.forName(AdvertisingIdClientClassName);
            Method getAdvertisingIdInfo = AdvertisingIdClient.getDeclaredMethod("getAdvertisingIdInfo", Context.class);
            Object adInfo = getAdvertisingIdInfo.invoke(null, EventService.context);
            return new AdvertisingInfo(AdvertisingInfoLoader.reflectedGetAdvertisingId(adInfo, null), AdvertisingInfoLoader.reflectedIsLimitAdTrackingEnabled(adInfo, false));
        }
        catch (Exception e) {
            CRTOLog.e("Unable to retrieve Google Ad ID", e);
            return null;
        }
    }

    private static String reflectedGetAdvertisingId(Object adInfo, String defaultValue) {
        try {
            Method getAdvertisingIdInfoMethodID = adInfo.getClass().getDeclaredMethod("getId", new Class[0]);
            return (String)getAdvertisingIdInfoMethodID.invoke(adInfo, new Object[0]);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static boolean reflectedIsLimitAdTrackingEnabled(Object adInfo, boolean defaultValue) {
        try {
            Method getAdvertisingIdInfoMethodLAT = adInfo.getClass().getDeclaredMethod("isLimitAdTrackingEnabled", new Class[0]);
            return (Boolean)getAdvertisingIdInfoMethodLAT.invoke(adInfo, new Object[0]);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

