/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events.product;

import android.util.Log;

public class Product {
    private final String productId;
    private final double price;

    public Product(String productId, double price) {
        this.productId = this.validateProductId(productId);
        this.price = this.validatePrice(price);
    }

    private String validateProductId(String productId) {
        if (productId == null) {
            Log.e((String)"[Criteo]", (String)"Argument productId must not be null");
            return "";
        }
        if (productId.length() == 0) {
            Log.e((String)"[Criteo]", (String)"Argument productId must be string of length greater than 0");
            return "";
        }
        return productId;
    }

    private double validatePrice(double price) {
        if (price < 0.0) {
            Log.e((String)"[Criteo]", (String)"Argument price must be greater than or equal to zero");
        }
        return price;
    }

    public String getProductId() {
        return this.productId;
    }

    public double getPrice() {
        return this.price;
    }
}

