/*
 * Decompiled with CFR 0.152.
 */
package com.criteo.events;

import android.content.pm.PackageManager;
import android.os.Build;
import com.criteo.events.AdvertisingInfo;
import com.criteo.events.AdvertisingInfoLoader;
import com.criteo.events.CRTOLog;
import com.criteo.events.EventService;
import java.util.Locale;

final class DeviceInfo {
    private static AdvertisingInfo advertisingInfo = null;

    private DeviceInfo() {
    }

    static String getAppVersion() {
        try {
            return EventService.context.getPackageManager().getPackageInfo((String)EventService.context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            CRTOLog.e("Error getting AppVersion", e);
            return "";
        }
    }

    static String getSDKVersion() {
        return "1.1.2";
    }

    static String getModel() {
        return Build.MODEL;
    }

    static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    static String getAndroidVersion() {
        return Build.VERSION.RELEASE;
    }

    static String getBundleName() {
        return EventService.context.getPackageName();
    }

    static String getCountry() {
        return Locale.getDefault().getCountry();
    }

    static String getLanguage() {
        return Locale.getDefault().getLanguage();
    }

    static String[] getCountriesList() {
        return Locale.getISOCountries();
    }

    static String[] getLanguageList() {
        return Locale.getISOLanguages();
    }

    static String getAdvertisingId() {
        if (advertisingInfo == null) {
            advertisingInfo = AdvertisingInfoLoader.getAdvertisingInfo();
        }
        return advertisingInfo != null ? advertisingInfo.getAdvertisingId() : null;
    }

    static boolean getLimitAdTrackingEnabled() {
        if (advertisingInfo == null) {
            advertisingInfo = AdvertisingInfoLoader.getAdvertisingInfo();
        }
        return advertisingInfo != null ? advertisingInfo.isLatEnabled() : false;
    }

    static void setIdentifiers(String GAID, boolean LAT) {
        advertisingInfo = new AdvertisingInfo(GAID, LAT);
    }
}

