/*
 * Decompiled with CFR 0.152.
 */
package com.creditdatamw.zerocell.handler;

import com.creditdatamw.zerocell.ReaderUtil;
import com.creditdatamw.zerocell.ZeroCellException;
import com.creditdatamw.zerocell.ZeroCellReader;
import com.creditdatamw.zerocell.annotation.Column;
import com.creditdatamw.zerocell.annotation.RowNumber;
import com.creditdatamw.zerocell.column.ColumnInfo;
import com.creditdatamw.zerocell.column.ColumnMapping;
import com.creditdatamw.zerocell.converter.Converter;
import com.creditdatamw.zerocell.converter.Converters;
import com.creditdatamw.zerocell.converter.NoopConverter;
import java.io.File;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityHandler<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityHandler.class);
    private static final String DEFAULT_SHEET = "uploads";
    private final Class<T> type;
    private final EntityExcelSheetHandler<T> entitySheetHandler;
    private final String sheetName;
    private final boolean skipHeaderRow;

    public EntityHandler(Class<T> clazz, boolean skipHeaderRow) {
        Objects.requireNonNull(clazz);
        this.type = clazz;
        this.sheetName = DEFAULT_SHEET;
        this.entitySheetHandler = this.createSheetHandler(clazz, null);
        this.skipHeaderRow = skipHeaderRow;
    }

    public EntityHandler(Class<T> clazz, String sheetName, boolean skipHeaderRow) {
        Objects.requireNonNull(clazz);
        this.type = clazz;
        this.sheetName = sheetName;
        this.entitySheetHandler = this.createSheetHandler(clazz, null);
        this.skipHeaderRow = skipHeaderRow;
    }

    public EntityHandler(Class<T> clazz, ColumnMapping columnMapping, boolean skipHeaderRow) {
        Objects.requireNonNull(clazz);
        this.type = clazz;
        this.sheetName = DEFAULT_SHEET;
        this.entitySheetHandler = this.createSheetHandler(clazz, columnMapping);
        this.skipHeaderRow = skipHeaderRow;
    }

    public EntityHandler(Class<T> clazz, String sheetName, ColumnMapping columnMapping, boolean skipHeaderRow) {
        Objects.requireNonNull(clazz);
        this.type = clazz;
        this.sheetName = sheetName;
        this.entitySheetHandler = this.createSheetHandler(clazz, columnMapping);
        this.skipHeaderRow = skipHeaderRow;
    }

    private EntityExcelSheetHandler<T> createSheetHandler(Class<T> clazz, ColumnMapping columnMapping) {
        if (columnMapping == null) {
            columnMapping = this.readColumnInfoViaReflection(clazz);
        }
        ColumnInfo rowNumberColumn = columnMapping.getRowNumberInfo();
        List<ColumnInfo> list = columnMapping.getColumns();
        ColumnInfo[] columns = new ColumnInfo[list.size()];
        int index = 0;
        for (ColumnInfo columnInfo : list) {
            index = columnInfo.getIndex();
            if (index > columns.length - 1) {
                throw new ZeroCellException("Column index out of range. index=" + index + " columnCount=" + columns.length + ". Ensure there @Column annotations for all indexes from 0 to " + (columns.length - 1));
            }
            if (!Objects.isNull(columns[index])) {
                throw new ZeroCellException("Cannot map two columns to the same index: " + index);
            }
            columns[index] = columnInfo;
        }
        return new EntityExcelSheetHandler(rowNumberColumn, columns);
    }

    private ColumnMapping readColumnInfoViaReflection(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>(fieldArray.length);
        ColumnInfo rowNumberColumn = null;
        for (Field field : fieldArray) {
            RowNumber rowNumberAnnotation = field.getAnnotation(RowNumber.class);
            if (!Objects.isNull(rowNumberAnnotation)) {
                rowNumberColumn = new ColumnInfo("__id__", field.getName(), -1, null, Integer.class, NoopConverter.class);
                continue;
            }
            Column annotation = field.getAnnotation(Column.class);
            if (Objects.isNull(annotation)) continue;
            Class<?> converter = annotation.convertorClass();
            list.add(new ColumnInfo(annotation.name().trim(), field.getName(), annotation.index(), annotation.dataFormat(), field.getType(), converter));
        }
        if (list.isEmpty()) {
            throw new ZeroCellException(String.format("Class %s does not have @Column annotations", clazz.getName()));
        }
        list.trimToSize();
        return new ColumnMapping(rowNumberColumn, list);
    }

    public List<T> readAsList() {
        List<T> list = Collections.unmodifiableList(this.entitySheetHandler.read(null, this.sheetName));
        return list;
    }

    public void process(File file) throws ZeroCellException {
        ReaderUtil.process(file, this.sheetName, this.entitySheetHandler);
    }

    private final class EntityExcelSheetHandler<T>
    implements ZeroCellReader {
        private final Logger LOGGER = LoggerFactory.getLogger(EntityExcelSheetHandler.class);
        private final ColumnInfo rowNumberColumn;
        private final ColumnInfo[] columns;
        private final List<T> entities;
        private final Converter NOOP_CONVERTER = new NoopConverter();
        private final Converter[] converters;
        private final int MAXIMUM_COL_INDEX;
        private boolean isHeaderRow = false;
        private int currentRow = -1;
        private int currentCol = -1;
        private T cur;

        EntityExcelSheetHandler(ColumnInfo rowNumberColumn, ColumnInfo[] columns) {
            this.rowNumberColumn = rowNumberColumn;
            this.columns = columns;
            this.converters = this.cacheConverters();
            this.entities = new ArrayList<T>();
            this.MAXIMUM_COL_INDEX = columns.length - 1;
        }

        private Converter[] cacheConverters() {
            Converter[] cv = new Converter[this.columns.length];
            for (ColumnInfo c : this.columns) {
                cv[c.getIndex()] = this.NOOP_CONVERTER;
                try {
                    if (c.getConverterClass().equals(NoopConverter.class)) continue;
                    cv[c.getIndex()] = (Converter)c.getConverterClass().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    this.LOGGER.error("Failed to instantiate Converter class: {}", c.getConverterClass());
                }
            }
            return cv;
        }

        @Override
        public List<T> read(File file, String sheet) {
            return Collections.unmodifiableList(this.entities);
        }

        void clear() {
            this.currentRow = -1;
            this.currentCol = -1;
            this.cur = null;
            this.entities.clear();
        }

        public void startRow(int i) {
            this.currentRow = i;
            if (this.currentRow == 0) {
                this.isHeaderRow = true;
                return;
            }
            this.isHeaderRow = false;
            try {
                this.cur = EntityHandler.this.type.newInstance();
                if (!Objects.isNull(this.rowNumberColumn)) {
                    this.writeColumnField(this.cur, String.valueOf(i), this.rowNumberColumn, i);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ZeroCellException("Failed to create and instance of " + EntityHandler.this.type.getName(), e);
            }
        }

        public void endRow(int i) {
            if (!Objects.isNull(this.cur)) {
                this.entities.add(this.cur);
                this.cur = null;
            }
        }

        public void cell(String cellReference, String formattedValue, XSSFComment xssfComment) {
            if (cellReference == null) {
                cellReference = new CellAddress(this.currentRow, this.currentCol).formatAsString();
            }
            short column = new CellReference(cellReference).getCol();
            this.currentCol = column;
            if (column > this.MAXIMUM_COL_INDEX) {
                this.LOGGER.warn("Invalid Column index found: " + column);
                return;
            }
            ColumnInfo currentColumnInfo = this.columns[column];
            if (this.isHeaderRow && !EntityHandler.this.skipHeaderRow && !currentColumnInfo.getName().equalsIgnoreCase(formattedValue.trim())) {
                throw new ZeroCellException(String.format("Expected Column '%s' but found '%s'", currentColumnInfo.getName(), formattedValue));
            }
            if (Objects.isNull(this.cur)) {
                return;
            }
            this.writeColumnField(this.cur, formattedValue, currentColumnInfo, this.currentRow);
        }

        private void writeColumnField(T object, String formattedValue, ColumnInfo currentColumnInfo, int rowNum) {
            String fieldName = currentColumnInfo.getFieldName();
            try {
                Converter converter = this.NOOP_CONVERTER;
                if (currentColumnInfo.getIndex() != -1 && currentColumnInfo.getIndex() < this.columns.length) {
                    converter = this.converters[currentColumnInfo.getIndex()];
                }
                Object value = null;
                if (converter instanceof NoopConverter) {
                    value = this.convertValueToType(currentColumnInfo.getType(), formattedValue, currentColumnInfo.getName(), rowNum);
                } else {
                    try {
                        value = converter.convert(formattedValue, currentColumnInfo.getName(), rowNum);
                    }
                    catch (Exception e) {
                        throw new ZeroCellException(String.format("%s threw an exception while trying to convert value %s ", converter.getClass().getName(), formattedValue), e);
                    }
                }
                Field field = EntityHandler.this.type.getDeclaredField(currentColumnInfo.getFieldName());
                boolean access = field.isAccessible();
                if (!access) {
                    field.setAccessible(true);
                }
                field.set(this.cur, value);
                field.setAccessible(field.isAccessible() && access);
            }
            catch (IllegalArgumentException e) {
                throw new ZeroCellException(String.format("Failed to write value %s to field %s at row %s", formattedValue, fieldName, rowNum));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                this.LOGGER.error("Failed to set field: {}", (Object)fieldName, (Object)e);
            }
        }

        public Object convertValueToType(Class<?> fieldType, String formattedValue, String columnName, int rowNum) {
            String value = null;
            if (fieldType == String.class) {
                value = String.valueOf(formattedValue);
            } else {
                if (fieldType == LocalDateTime.class) {
                    return Converters.toLocalDateTime.convert(formattedValue, columnName, rowNum);
                }
                if (fieldType == LocalDate.class) {
                    return Converters.toLocalDate.convert(formattedValue, columnName, rowNum);
                }
                if (fieldType == Date.class) {
                    return Converters.toSqlDate.convert(formattedValue, columnName, rowNum);
                }
                if (fieldType == Timestamp.class) {
                    return Converters.toSqlTimestamp.convert(formattedValue, columnName, rowNum);
                }
                if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                    return Converters.toInteger.convert(formattedValue, columnName, rowNum);
                }
                if (fieldType == Long.class || fieldType == Long.TYPE) {
                    return Converters.toLong.convert(formattedValue, columnName, rowNum);
                }
                if (fieldType == Double.class || fieldType == Double.TYPE) {
                    return Converters.toDouble.convert(formattedValue, columnName, rowNum);
                }
                if (fieldType == Float.class || fieldType == Float.TYPE) {
                    return Converters.toFloat.convert(formattedValue, columnName, rowNum);
                }
                if (fieldType == Boolean.class) {
                    return Converters.toBoolean.convert(formattedValue, columnName, rowNum);
                }
            }
            return value;
        }

        public void headerFooter(String text, boolean b, String tagName) {
        }
    }
}

