/*
 * Decompiled with CFR 0.152.
 */
package com.creditdatamw.zerocell.column;

import com.creditdatamw.zerocell.annotation.Column;
import com.creditdatamw.zerocell.converter.NoopConverter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public class ColumnInfo {
    private String name;
    private String fieldName;
    private int index;
    private String dataFormat;
    private Class<?> type;
    private Class<?> converterClass;

    public ColumnInfo(String name, String fieldName, int index, Class<?> dataType) {
        this.name = name;
        this.fieldName = fieldName;
        this.index = index;
        this.dataFormat = "";
        this.type = dataType;
        this.converterClass = NoopConverter.class;
    }

    public ColumnInfo(String name, String fieldName, int index, String dataFormat, Class<?> type, Class<?> converterClass) {
        this.name = name;
        this.fieldName = fieldName;
        this.index = index;
        this.dataFormat = dataFormat;
        this.type = type;
        this.converterClass = converterClass;
    }

    public String getName() {
        return this.name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getIndex() {
        return this.index;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Class<?> getConverterClass() {
        return this.converterClass;
    }

    public static final List<Column> annotationsOf(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        ArrayList<Column> columns = new ArrayList<Column>(fieldArray.length);
        for (Field field : fieldArray) {
            Column annotation = field.getAnnotation(Column.class);
            if (Objects.isNull(annotation)) continue;
            columns.add(annotation);
        }
        return columns;
    }

    public static final String[] columnsOf(Class<?> clazz) {
        List<Column> columns = ColumnInfo.annotationsOf(clazz);
        String[] columnNames = new String[columns.size()];
        LoggerFactory.getLogger(ColumnInfo.class).debug(String.format("Found %s columns in class %s", columnNames.length, clazz.getName()));
        for (Column annotation : columns) {
            columnNames[annotation.index()] = annotation.name().trim();
        }
        columns = null;
        return columnNames;
    }
}

