/*
 * Decompiled with CFR 0.152.
 */
package com.creditdatamw.zerocell;

import com.creditdatamw.zerocell.SheetNotFoundException;
import com.creditdatamw.zerocell.ZeroCellException;
import com.creditdatamw.zerocell.ZeroCellReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Objects;
import org.apache.poi.EmptyFileException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.NotOfficeXmlFileException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.util.SAXHelper;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.StylesTable;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class ReaderUtil {
    public static void process(File file, String sheetName, ZeroCellReader reader) {
        try (FileInputStream fis = new FileInputStream(file);){
            ReaderUtil.process(fis, sheetName, reader);
        }
        catch (IOException ioe) {
            throw new ZeroCellException("Failed to process file", ioe);
        }
    }

    public static void process(InputStream is, String sheetName, ZeroCellReader reader) {
        try (PushbackInputStream p = new PushbackInputStream(is, 16);
             OPCPackage opcPackage = OPCPackage.open((InputStream)p);){
            DataFormatter dataFormatter = new DataFormatter();
            ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(opcPackage);
            XSSFReader xssfReader = new XSSFReader(opcPackage);
            StylesTable stylesTable = xssfReader.getStylesTable();
            InputStream sheetInputStream = null;
            XSSFReader.SheetIterator sheets = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            while (sheets.hasNext()) {
                sheetInputStream = sheets.next();
                if (sheets.getSheetName().equalsIgnoreCase(sheetName)) break;
                sheetInputStream = null;
            }
            if (Objects.isNull(sheetInputStream)) {
                throw new SheetNotFoundException(sheetName);
            }
            XMLReader xmlReader = SAXHelper.newXMLReader();
            xmlReader.setContentHandler((ContentHandler)new XSSFSheetXMLHandler(stylesTable, strings, (XSSFSheetXMLHandler.SheetContentsHandler)reader, dataFormatter, false));
            xmlReader.parse(new InputSource(sheetInputStream));
            sheetInputStream.close();
            xmlReader = null;
            sheetInputStream = null;
            stylesTable = null;
            strings = null;
            xssfReader = null;
        }
        catch (EmptyFileException | InvalidFormatException | NotOfficeXmlFileException ife) {
            throw new ZeroCellException("Cannot load file. The file must be an Excel 2007+ Workbook (.xlsx)");
        }
        catch (SheetNotFoundException ex) {
            throw new ZeroCellException(ex.getMessage());
        }
        catch (ZeroCellException ze) {
            throw ze;
        }
        catch (Exception e) {
            throw new ZeroCellException("Failed to process file", e);
        }
    }
}

