/*
 * Decompiled with CFR 0.152.
 */
package com.creditdatamw.zerocell;

import com.creditdatamw.zerocell.column.ColumnInfo;
import com.creditdatamw.zerocell.column.ColumnMapping;
import com.creditdatamw.zerocell.column.RowNumberInfo;
import com.creditdatamw.zerocell.handler.EntityHandler;
import java.io.File;
import java.util.List;
import java.util.Objects;

public class Reader {
    public static <T> String[] columnsOf(Class<T> clazz) {
        return ColumnInfo.columnsOf(clazz);
    }

    public static <T> ReaderBuilder<T> of(Class<T> clazz) {
        return new ReaderBuilder<T>(clazz);
    }

    public static final class ReaderBuilder<T> {
        private final Class<T> clazz;
        private File file;
        private String sheetName;
        private ColumnMapping columnMapping;
        private boolean skipHeaderRow = false;

        public ReaderBuilder(Class<T> clazz) {
            this.clazz = clazz;
        }

        public ReaderBuilder<T> from(File file) {
            Objects.requireNonNull(file);
            this.file = file;
            return this;
        }

        public ReaderBuilder<T> using(RowNumberInfo rowNumberInfo, ColumnInfo ... columns) {
            this.columnMapping = new ColumnMapping((ColumnInfo)rowNumberInfo, columns);
            return this;
        }

        public ReaderBuilder<T> using(ColumnInfo ... columns) {
            this.columnMapping = new ColumnMapping(null, columns);
            return this;
        }

        public ReaderBuilder<T> sheet(String sheetName) {
            Objects.requireNonNull(sheetName);
            this.sheetName = sheetName;
            return this;
        }

        public ReaderBuilder<T> skipHeaderRow(boolean value) {
            this.skipHeaderRow = value;
            return this;
        }

        public <T> List<T> list() {
            EntityHandler<T> entityHandler = !Objects.isNull(this.sheetName) && !Objects.isNull(this.columnMapping) ? new EntityHandler<T>(this.clazz, this.sheetName, this.columnMapping, this.skipHeaderRow) : (Objects.isNull(this.sheetName) && !Objects.isNull(this.columnMapping) ? new EntityHandler<T>(this.clazz, this.columnMapping, this.skipHeaderRow) : (!Objects.isNull(this.sheetName) && Objects.isNull(this.columnMapping) ? new EntityHandler<T>(this.clazz, this.sheetName, this.skipHeaderRow) : new EntityHandler<T>(this.clazz, this.skipHeaderRow)));
            entityHandler.process(this.file);
            return entityHandler.readAsList();
        }
    }
}

