/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.doc.module.substitution.markdown.table;

import com.credibledoc.substitution.core.resource.ResourceService;
import com.credibledoc.substitution.core.template.TemplateService;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.javadoc.Javadoc;
import javax.inject.Inject;
import net.steppschuh.markdowngenerator.table.Table;
import org.springframework.stereotype.Service;

@Service
public class TableService {
    private static final String EMPTY_STRING = "";
    private static final String ONE_SPACE = " ";
    private static final String NEW_LINE = "\\r\\n|\\n";

    public String createMarkdownTableFromEnum(Table.Builder tableBuilder, Class<?> enumClass) {
        String resourceRelativePath = ResourceService.getInstance().getResource(enumClass);
        String sourceCode = TemplateService.getInstance().getTemplateContent(resourceRelativePath);
        CompilationUnit compilationUnit = JavaParser.parse((String)sourceCode);
        EnumDeclaration enumDeclaration = (EnumDeclaration)compilationUnit.getTypes().get(0);
        for (EnumConstantDeclaration enumConstantDeclaration : enumDeclaration.getEntries()) {
            String name = enumConstantDeclaration.getName().asString();
            String javadocString = EMPTY_STRING;
            Javadoc javadoc = enumConstantDeclaration.getJavadoc().orElse(null);
            if (javadoc != null) {
                javadocString = javadoc.toText().replaceAll(NEW_LINE, ONE_SPACE);
            }
            tableBuilder.addRow(new Object[]{name, javadocString});
        }
        return tableBuilder.build().toString();
    }

    @Inject
    public TableService() {
    }
}

