/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.doc.module.substitution.activity;

import com.credibledoc.enricher.deriving.Printable;
import com.credibledoc.enricher.line.LineProcessor;
import com.credibledoc.enricher.line.LineProcessorService;
import com.credibledoc.enricher.searchcommand.SearchCommand;
import com.credibledoc.enricher.transformer.Transformer;
import com.credibledoc.substitution.doc.module.substitution.activity.ActivityUmlReportService;
import com.credibledoc.substitution.doc.module.substitution.activity.anyline.AnyLineSearchCommand;
import com.credibledoc.substitution.doc.module.substitution.report.UmlDiagramType;
import com.credibledoc.substitution.reporting.report.document.Document;
import com.credibledoc.substitution.reporting.reportdocument.ReportDocument;
import com.credibledoc.substitution.reporting.reportdocument.ReportDocumentType;
import com.credibledoc.substitution.reporting.reportdocument.creator.ReportDocumentCreator;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import javax.inject.Inject;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ActivityUmlReportService
implements ReportDocumentCreator {
    private static final Logger log = LoggerFactory.getLogger(ActivityUmlReportService.class);
    @NonNull
    private final ApplicationContext applicationContext;

    public ReportDocument prepareReportDocument() {
        Document document = new Document();
        document.setReportDocumentType(UmlDiagramType.class);
        ArrayList<LineProcessor> lineProcessors = new ArrayList<LineProcessor>();
        lineProcessors.add(new LineProcessor((SearchCommand)this.applicationContext.getBean(AnyLineSearchCommand.class), (Transformer)this.applicationContext.getBean(AnyLineTransformer.class), (Printable)document));
        LineProcessorService.getInstance().getLineProcessors().addAll(lineProcessors);
        log.info("Line processors prepared");
        return document;
    }

    public Class<? extends ReportDocumentType> getReportDocumentType() {
        return UmlDiagramType.class;
    }

    @ConstructorProperties(value={"applicationContext"})
    @Inject
    public ActivityUmlReportService(@NonNull ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext");
        }
        this.applicationContext = applicationContext;
    }
}

