# Examples of PlantUML diagrams generated by the `substitution-core` library

## Activity diagram
After launching the application generates a log file in the `log` directory.
This log will be used as a recording of the tool behavior. Application uses its
own `substitution-doc.log` for generation of UML diagrams like this one, see below.

This diagram shows the first steps the application performs after launching.

&&beginPlaceholder {
    "className": "com.credibledoc.substitution.doc.module.substitution.launching.LaunchingUmlReportService",
    "description": "Diagram of the application launching created from substitution-doc.log.",
    "parameters": {"sourceFileRelativePath": "log/substitution-doc.log"}
} &&endPlaceholder

This diagram is shorter then the next one because the application generated a part
of log file only when it loaded this log file.

If you will launch the application more times then more log files will be created,
for example `substitution-doc_1.log`, `substitution-doc_2.log` and so on, as
configured in `src/main/resources/logback.xml` file. The next diagram is
generated from `substitution-doc_1.log` file and contains behavior from previous
launching. This diagram is longer because the application loaded the whole
log file generated during the previous launching.

&&beginPlaceholder {
    "className": "com.credibledoc.substitution.doc.module.substitution.launching.LaunchingUmlReportService",
    "description": "Diagram of the application launching created from substitution-doc_1.log.",
    "parameters": {"sourceFileRelativePath": "log/substitution-doc_1.log"}
} &&endPlaceholder

### Activity diagram with swimlanes
This Activity diagram shows main steps of the application activity parsed from a
substitution-doc_1.log file. 

&&beginPlaceholder {
    "className": "com.credibledoc.substitution.doc.module.substitution.activity.anyline.ActivityUmlReportService",
    "description": "Diagram of the previous application launching.",
    "parameters": {"sourceFileRelativePath": "log/substitution-doc_1.log"}
} &&endPlaceholder

### Modules - based activity diagram
This diagram shows the application activity divided to swimlanes. Each swimlane
represents a module and each square element represents an event in the module.
This diagram is generated from parsed substitution-doc_1.log file.

&&beginPlaceholder {
    "className": "com.credibledoc.substitution.doc.module.substitution.activity.modules.ModulesActivityUmlReportService",
    "description": "Credibledoc modules - based activity diagram.",
    "parameters": {"sourceFileRelativePath": "log/substitution-doc_1.log"}
} &&endPlaceholder

### Dependencies between packages
&&beginPlaceholder {
    "className": "com.credibledoc.substitution.content.generator.dependency.PackageDependenciesContentGenerator",
    "description": "Dependency of the `com.credibledoc.substitution.doc` package on other classes in the `com.credibledoc.substitution` package.",
    "parameters": {
        "sourceRelativePathsPipeSeparated": "substitution-doc/src/main/java",
        "dependantPackage": "com.credibledoc.substitution.doc",
        "dependenciesPackagesPipeSeparated": "com.credibledoc.substitution",
        "ignoreInnerPackages": "true"}
} &&endPlaceholder
