/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.doc.module.substitution.logmessage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class LogMessageService {
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String LOG_SEPARATOR = " - ";
    public static final String DOT = ".";
    public static final String FOUR_SPACES = "    ";
    private static final String WORDS_SEPARATOR = " ";
    private static final String BACKWARD_SLASH = "\\";
    private static final List<String> FORBIDDEN_SUFFIXES = Arrays.asList("~;", "/");

    public String parseMessage(String line, int maxRowLength) {
        int separatorIndex = line.indexOf(LOG_SEPARATOR);
        String[] tokens = line.substring(separatorIndex + LOG_SEPARATOR.length()).split("\\s");
        tokens = this.splitLongTokens(tokens, maxRowLength);
        StringBuilder result = new StringBuilder(line.length());
        StringBuilder row = new StringBuilder(line.length());
        for (int i = 0; i < tokens.length; ++i) {
            boolean isShortRow;
            boolean hasMoreTokens;
            if ("}".equals(tokens[i].trim())) {
                row.insert(row.length() - 1, tokens[i].trim());
                tokens[i] = "";
            }
            String escapedToken = this.escapeToken(tokens[i]);
            boolean bl = hasMoreTokens = i + 1 < tokens.length;
            if (hasMoreTokens) {
                escapedToken = this.moveForbiddenSuffixToNextLine(tokens, i, escapedToken);
            }
            boolean bl2 = isShortRow = row.length() + escapedToken.length() + WORDS_SEPARATOR.length() < maxRowLength;
            if (isShortRow) {
                this.appendEscapedToRow(maxRowLength, row, escapedToken, hasMoreTokens);
                continue;
            }
            if (row.toString().endsWith(BACKWARD_SLASH)) {
                row.replace(row.length() - 1, row.length(), "");
                escapedToken = BACKWARD_SLASH + escapedToken;
            }
            result.append((CharSequence)row);
            result.append(LINE_SEPARATOR);
            row = new StringBuilder(line.length()).append(FOUR_SPACES);
            this.appendEscapedToRow(maxRowLength, row, escapedToken, hasMoreTokens);
        }
        result.append((CharSequence)row);
        return result.toString();
    }

    private String moveForbiddenSuffixToNextLine(String[] tokens, int i, String escapedToken) {
        int notAllowedSuffixIndex = this.getForbiddenSuffixIndex(escapedToken);
        if (notAllowedSuffixIndex > -1) {
            String suffix = (String)FORBIDDEN_SUFFIXES.get(notAllowedSuffixIndex);
            if (tokens.length > i + 2) {
                tokens[i + 1] = suffix + tokens[i + 1];
            }
            escapedToken = escapedToken.substring(0, escapedToken.length() - suffix.length());
        }
        return escapedToken;
    }

    private int getForbiddenSuffixIndex(String token) {
        for (int i = 0; i < FORBIDDEN_SUFFIXES.size(); ++i) {
            if (!token.endsWith((String)FORBIDDEN_SUFFIXES.get(i))) continue;
            return i;
        }
        return -1;
    }

    private String[] splitLongTokens(String[] tokens, int maxRowLength) {
        ArrayList<String> result = new ArrayList<String>();
        for (String token : tokens) {
            if (token.length() <= maxRowLength) {
                result.add(token);
                continue;
            }
            while (token.length() > maxRowLength) {
                result.add(token.substring(0, maxRowLength));
                token = token.substring(maxRowLength);
            }
            if (token.length() <= 0) continue;
            result.add(token);
        }
        return result.toArray(new String[0]);
    }

    private String escapeToken(String token) {
        return token.replaceAll(";", "~;").replaceAll("'", "");
    }

    private void appendEscapedToRow(int maxRowLength, StringBuilder row, String replaced, boolean hasMoreTokens) {
        row.append(replaced);
        if (row.length() < maxRowLength && hasMoreTokens) {
            row.append(WORDS_SEPARATOR);
        }
    }
}

