/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.doc;

import com.credibledoc.combiner.tactic.TacticService;
import com.credibledoc.substitution.core.configuration.Configuration;
import com.credibledoc.substitution.core.configuration.ConfigurationService;
import com.credibledoc.substitution.core.resource.ResourceService;
import com.credibledoc.substitution.core.template.TemplateService;
import com.credibledoc.substitution.doc.module.substitution.SubstitutionTactic;
import com.credibledoc.substitution.reporting.markdown.MarkdownService;
import com.credibledoc.substitution.reporting.reportdocument.ReportDocumentType;
import com.credibledoc.substitution.reporting.reportdocument.creator.ReportDocumentCreator;
import com.credibledoc.substitution.reporting.reportdocument.creator.ReportDocumentCreatorService;
import com.credibledoc.substitution.reporting.visualizer.VisualizerService;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.ComponentScan;

@ComponentScan(basePackages={"com.credibledoc.substitution.doc"})
public class SubstitutionDocMain {
    private static final Logger log = LoggerFactory.getLogger(SubstitutionDocMain.class);
    public static final String APPLICATION_SUBSTITUTION_DOC_LAUNCHED = "Application substitution-doc launched.";
    public static final String SUBSTITUTION_DOC = "substitution-doc";
    public static final String APPLICATION_SUBSTITUTION_DOC_FINISHED = "Application finished.";
    @NonNull
    private final List<ReportDocumentCreator> reportDocumentCreators;
    @NonNull
    private final SubstitutionTactic substitutionSpecificTactic;

    public static void main(String[] args) {
        log.info(APPLICATION_SUBSTITUTION_DOC_LAUNCHED);
        try (AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext(new Class[]{SubstitutionDocMain.class});){
            applicationContext.start();
            log.info("Spring ApplicationContext created and started");
            SubstitutionDocMain substitutionDocMain = (SubstitutionDocMain)applicationContext.getBean(SubstitutionDocMain.class);
            substitutionDocMain.substitute();
        }
        log.info(APPLICATION_SUBSTITUTION_DOC_FINISHED);
    }

    private void substitute() {
        TacticService.getInstance().getTactics().add(this.substitutionSpecificTactic);
        ReportDocumentCreatorService reportDocumentCreatorService = ReportDocumentCreatorService.getInstance();
        reportDocumentCreatorService.addReportDocumentCreators((Collection)this.reportDocumentCreators);
        reportDocumentCreatorService.createReportDocuments();
        this.copyResourcesToTargetDirectory();
        VisualizerService.getInstance().createReports(Collections.singletonList(ReportDocumentType.DOCUMENT_PART_UML));
        MarkdownService.getInstance().generateContentFromTemplates();
    }

    private void copyResourcesToTargetDirectory() {
        Configuration configuration = ConfigurationService.getInstance().getConfiguration();
        ResourceService resourceService = ResourceService.getInstance();
        List allResources = resourceService.getResources(null, configuration.getTemplatesResource());
        TemplateService templateService = TemplateService.getInstance();
        for (String resource : allResources) {
            if (resource.endsWith(".md") || !this.containsDotInName(resource)) continue;
            String targetFilePath = resourceService.generatePlaceholderResourceRelativePath(resource);
            String targetFileAbsolutePath = configuration.getTargetDirectory() + targetFilePath;
            log.info("Resource will be copied to file. Resource: '{}'. TargetFileAbsolutePath: '{}'", (Object)resource, (Object)targetFileAbsolutePath);
            File file = templateService.exportResource(resource, targetFileAbsolutePath);
            log.info("Resource copied to file: '{}'", (Object)file.getAbsolutePath());
        }
    }

    private boolean containsDotInName(String resource) {
        int index = resource.lastIndexOf(47);
        if (index == -1) {
            index = 0;
        }
        String fileName = resource.substring(index);
        return fileName.contains(".");
    }

    @ConstructorProperties(value={"reportDocumentCreators", "substitutionSpecificTactic"})
    @Inject
    public SubstitutionDocMain(@NonNull List<ReportDocumentCreator> reportDocumentCreators, @NonNull SubstitutionTactic substitutionSpecificTactic) {
        if (reportDocumentCreators == null) {
            throw new NullPointerException("reportDocumentCreators");
        }
        if (substitutionSpecificTactic == null) {
            throw new NullPointerException("substitutionSpecificTactic");
        }
        this.reportDocumentCreators = reportDocumentCreators;
        this.substitutionSpecificTactic = substitutionSpecificTactic;
    }
}

