/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.doc.module.substitution.logmessage;

import java.util.ArrayList;
import org.springframework.stereotype.Service;

@Service
public class LogMessageService {
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String LOG_SEPARATOR = " - ";
    public static final String DOT = ".";
    public static final String FOUR_SPACES = "    ";
    private static final String WORDS_SEPARATOR = " ";
    private static final String BACKWARD_SLASH = "\\";
    private static final String NOT_ALLOWED_AT_THE_END = "~;";

    public String parseMessage(String line, int maxRowLength) {
        int separatorIndex = line.indexOf(LOG_SEPARATOR);
        String[] tokens = line.substring(separatorIndex + LOG_SEPARATOR.length()).split("\\s");
        tokens = this.splitLongTokens(tokens, maxRowLength);
        StringBuilder result = new StringBuilder(line.length());
        StringBuilder row = new StringBuilder(line.length());
        for (int i = 0; i < tokens.length; ++i) {
            boolean isShortRow;
            String escapedToken;
            if ("}".equals(tokens[i].trim())) {
                row.insert(row.length() - 1, tokens[i].trim());
                tokens[i] = "";
            }
            if ((escapedToken = this.escapeToken(tokens[i])).endsWith(NOT_ALLOWED_AT_THE_END)) {
                if (tokens.length > i + 2) {
                    tokens[i + 1] = NOT_ALLOWED_AT_THE_END + tokens[i + 1];
                }
                escapedToken = escapedToken.substring(0, escapedToken.length() - 2);
            }
            boolean hasMoreTokens = i + 1 < tokens.length;
            boolean bl = isShortRow = row.length() + escapedToken.length() + WORDS_SEPARATOR.length() < maxRowLength;
            if (isShortRow) {
                this.appendEscapedToRow(maxRowLength, row, escapedToken, hasMoreTokens);
                continue;
            }
            if (row.toString().endsWith(BACKWARD_SLASH)) {
                row.replace(row.length() - 1, row.length(), "");
                escapedToken = BACKWARD_SLASH + escapedToken;
            }
            result.append((CharSequence)row);
            result.append(LINE_SEPARATOR);
            row = new StringBuilder(line.length()).append(FOUR_SPACES);
            this.appendEscapedToRow(maxRowLength, row, escapedToken, hasMoreTokens);
        }
        result.append((CharSequence)row);
        return result.toString();
    }

    private String[] splitLongTokens(String[] tokens, int maxRowLength) {
        ArrayList<String> result = new ArrayList<String>();
        for (String token : tokens) {
            if (token.length() <= maxRowLength) {
                result.add(token);
                continue;
            }
            while (token.length() > maxRowLength) {
                result.add(token.substring(0, maxRowLength));
                token = token.substring(maxRowLength);
            }
            if (token.length() <= 0) continue;
            result.add(token);
        }
        return result.toArray(new String[0]);
    }

    private String escapeToken(String token) {
        return token.replaceAll(";", NOT_ALLOWED_AT_THE_END).replaceAll("'", "");
    }

    private void appendEscapedToRow(int maxRowLength, StringBuilder row, String replaced, boolean hasMoreTokens) {
        row.append(replaced);
        if (row.length() < maxRowLength && hasMoreTokens) {
            row.append(WORDS_SEPARATOR);
        }
    }
}

