/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.doc.module.substitution.pom;

import com.credibledoc.substitution.core.content.Content;
import com.credibledoc.substitution.core.content.ContentGenerator;
import com.credibledoc.substitution.core.exception.SubstitutionRuntimeException;
import com.credibledoc.substitution.core.placeholder.Placeholder;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Scanner;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JarNameContentGenerator
implements ContentGenerator {
    private static final Logger log = LoggerFactory.getLogger(JarNameContentGenerator.class);
    private static final String NOT_PUBLISHED_YET = "'The artifact not published yet.'";
    private static final String TEXT_XML = "text/xml";
    private static final String ARTIFACT_ID_BEGIN_TAG = "<artifactId>";
    private static final String ARTIFACT_ID_END_TAG = "</artifactId>";
    private static final String LATEST_BEGIN_TAG = "<latest>";
    private static final String LATEST_END_TAG = "</latest>";

    public Content generate(Placeholder placeholder) {
        String url = (String)placeholder.getParameters().get("url");
        if (url == null) {
            throw new SubstitutionRuntimeException("Placeholder parameter 'url' is required, but found 'null'.");
        }
        return this.loadJarName(url);
    }

    private Content loadJarName(String urlParameter) {
        String result;
        try {
            URL url = new URL(urlParameter);
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            int responseCode = httpConn.getResponseCode();
            if (responseCode == 200) {
                String contentType = httpConn.getContentType();
                if (!TEXT_XML.equals(contentType)) {
                    throw new SubstitutionRuntimeException("Expected 'text/xml', but found " + contentType);
                }
                InputStream inputStream = httpConn.getInputStream();
                String xmlString = this.convertStreamToString(inputStream);
                String artifactId = this.parseTag(xmlString, ARTIFACT_ID_BEGIN_TAG, ARTIFACT_ID_END_TAG);
                String latestVersion = this.parseTag(xmlString, LATEST_BEGIN_TAG, LATEST_END_TAG);
                result = artifactId + "-" + latestVersion + ".jar";
            } else {
                log.info("ResponseCode is " + responseCode);
                result = NOT_PUBLISHED_YET;
            }
            httpConn.disconnect();
        }
        catch (Exception e) {
            throw new SubstitutionRuntimeException((Throwable)e);
        }
        Content content = new Content();
        content.setMarkdownContent(result);
        return content;
    }

    private String parseTag(String xmlString, String beginTag, String endTag) {
        int beginIndex = xmlString.indexOf(beginTag);
        if (beginIndex == -1) {
            throw new SubstitutionRuntimeException("Cannot find " + beginTag);
        }
        int endIndex = xmlString.indexOf(endTag, beginIndex);
        if (endIndex == -1) {
            throw new SubstitutionRuntimeException("Cannot find " + endTag);
        }
        return xmlString.substring(beginIndex + beginTag.length(), endIndex);
    }

    private String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    @Inject
    public JarNameContentGenerator() {
    }
}

