/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.doc.module.substitution.participant;

import com.credibledoc.substitution.core.content.Content;
import com.credibledoc.substitution.core.content.ContentGenerator;
import com.credibledoc.substitution.core.placeholder.Placeholder;
import com.credibledoc.substitution.doc.module.substitution.markdown.table.TableService;
import com.credibledoc.substitution.doc.plantuml.Participant;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import lombok.NonNull;
import net.steppschuh.markdowngenerator.table.Table;
import org.springframework.stereotype.Service;

@Service
public class ParticipantsTableMarkdownGenerator
implements ContentGenerator {
    @NonNull
    private final TableService tableService;

    public Content generate(Placeholder placeholder) {
        Table.Builder tableBuilder = new Table.Builder().addRow(new Object[]{"Participant name", "Description"});
        String markdown = this.tableService.createMarkdownTableFromEnum(tableBuilder, Participant.class);
        Content content = new Content();
        content.setMarkdownContent(markdown);
        return content;
    }

    @ConstructorProperties(value={"tableService"})
    @Inject
    public ParticipantsTableMarkdownGenerator(@NonNull TableService tableService) {
        if (tableService == null) {
            throw new NullPointerException("tableService");
        }
        this.tableService = tableService;
    }
}

