/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.doc.module.substitution.activity.modules;

import com.credibledoc.combiner.log.buffered.LogBufferedReader;
import com.credibledoc.enricher.deriving.Deriving;
import com.credibledoc.enricher.transformer.Transformer;
import com.credibledoc.plantuml.svggenerator.SvgGeneratorService;
import com.credibledoc.substitution.content.generator.jar.LocalJarNameContentGenerator;
import com.credibledoc.substitution.doc.module.substitution.exception.SubstitutionDocRuntimeException;
import com.credibledoc.substitution.doc.module.substitution.logmessage.LogMessageService;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import lombok.NonNull;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ModulesActivityTransformer
implements Transformer {
    @NonNull
    public final LogMessageService logMessageService;
    private static final String PLANTUML_CORE_MODULE_NAME = "plantuml-core";
    private static Map<String, String> packagePrefixToModuleName = new HashMap();

    private static void validatePackagesExist() {
        HashSet<String> foundPrefixes = new HashSet<String>();
        for (Package pkg : Package.getPackages()) {
            String name = pkg.getName();
            for (String prefix : packagePrefixToModuleName.keySet()) {
                if (!name.startsWith(prefix)) continue;
                foundPrefixes.add(prefix);
                if (foundPrefixes.size() != packagePrefixToModuleName.size()) continue;
                return;
            }
        }
        HashSet missingPrefixes = new HashSet(packagePrefixToModuleName.keySet());
        missingPrefixes.removeAll(foundPrefixes);
        throw new SubstitutionDocRuntimeException("Package(s) not found: " + missingPrefixes);
    }

    public String transform(Deriving deriving, List<String> multiLine, LogBufferedReader logBufferedReader) {
        String canonicalClassName = this.parseClassName(multiLine.get(0));
        String moduleName = this.findModuleName(canonicalClassName);
        int maxRowLength = moduleName.length() * 2 + moduleName.length() / 2;
        List cacheLines = deriving.getCacheLines();
        this.addMessageToCache(multiLine, moduleName, maxRowLength, cacheLines);
        return null;
    }

    private String findModuleName(String canonicalClassName) {
        for (Map.Entry entry : packagePrefixToModuleName.entrySet()) {
            if (!canonicalClassName.startsWith((String)entry.getKey())) continue;
            return (String)entry.getValue();
        }
        throw new SubstitutionDocRuntimeException("Module name cannot be found for package: " + canonicalClassName);
    }

    private void addMessageToCache(List<String> multiLine, String canonicalClassName, int maxRowLength, List<String> cacheLines) {
        String message = this.logMessageService.parseMessage(multiLine.get(0), maxRowLength);
        String result = "|" + canonicalClassName + "|" + LogMessageService.LINE_SEPARATOR + "    " + ":" + message + ";" + LogMessageService.LINE_SEPARATOR;
        cacheLines.add(result);
    }

    private String parseClassName(String line) {
        int separatorIndex = line.indexOf(" - ");
        String firstPart = line.substring(0, separatorIndex);
        int startIndex = firstPart.lastIndexOf(124) + 1;
        return firstPart.substring(startIndex);
    }

    @ConstructorProperties(value={"logMessageService"})
    @Inject
    public ModulesActivityTransformer(@NonNull LogMessageService logMessageService) {
        if (logMessageService == null) {
            throw new NullPointerException("logMessageService");
        }
        this.logMessageService = logMessageService;
    }

    static {
        packagePrefixToModuleName.put("com.credibledoc.substitution.core", "substitution-core");
        packagePrefixToModuleName.put("com.credibledoc.substitution.doc", "substitution-doc");
        packagePrefixToModuleName.put("com.credibledoc.plantuml", "plantuml-core");
        packagePrefixToModuleName.put("com.credibledoc.combiner", "log-combiner-core");
        packagePrefixToModuleName.put("com.credibledoc.substitution.content.generator", "substitution-generators");
        packagePrefixToModuleName.put("com.credibledoc.substitution.reporting", "substitution-reporting");
        packagePrefixToModuleName.put("org.springframework.context.annotation", "spring-libraries");
        SvgGeneratorService.class.getPackage();
        LocalJarNameContentGenerator.class.getPackage();
        ModulesActivityTransformer.validatePackagesExist();
    }
}

