/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.doc.module.substitution;

import com.credibledoc.combiner.date.DateService;
import com.credibledoc.combiner.log.buffered.LogBufferedReader;
import com.credibledoc.combiner.log.buffered.LogFileReader;
import com.credibledoc.combiner.node.file.NodeFile;
import com.credibledoc.combiner.tactic.Tactic;
import com.credibledoc.substitution.core.exception.SubstitutionRuntimeException;
import java.io.File;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.springframework.stereotype.Service;

@Service
public class SubstitutionTactic
implements Tactic {
    private static final String PATTERN_DATE_STRING = "\\d\\d\\.\\d\\d\\.\\d\\d\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d\\d\\d";
    private static final Pattern PATTERN_DATE = Pattern.compile("\\d\\d\\.\\d\\d\\.\\d\\d\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d\\d\\d");
    private static final String DATE_FORMAT_STRING = "dd.MM.yyyy HH:mm:ss.SSS";
    private static final String ONE_SPACE = " ";
    private static final int THREAD_NAME_INDEX = 35;
    private static final String PIPE = "|";
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date findDate(File file) {
        try (LogBufferedReader logBufferedReader = new LogBufferedReader((Reader)new LogFileReader(file));){
            String line = logBufferedReader.readLine();
            while (line != null) {
                Date date = this.parseDateFromLine(line);
                if (date != null) {
                    Date date2 = date;
                    return date2;
                }
                line = logBufferedReader.readLine();
            }
            Date date = null;
            return date;
        }
        catch (Exception e) {
            throw new SubstitutionRuntimeException("Cannot find date. File: " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public Date findDate(String line, NodeFile nodeFile) {
        return this.parseDateFromLine(line);
    }

    public boolean containsDate(String line) {
        if (line == null) {
            return false;
        }
        return PATTERN_DATE.matcher(line).find();
    }

    public String parseDateStingFromLine(String line) {
        if (line == null) {
            return null;
        }
        return this.findDateString(line);
    }

    private Date parseDateFromLine(String line) {
        if (line == null) {
            return null;
        }
        try {
            String clientDateString = this.findDateString(line);
            if (clientDateString != null) {
                return this.simpleDateFormat.parse(clientDateString);
            }
            return null;
        }
        catch (Exception e) {
            throw new SubstitutionRuntimeException("Cannot parse a date from the line: " + line, (Throwable)e);
        }
    }

    private String findDateString(String line) {
        int maxLength = line.length() > 90 ? 90 : line.length();
        String dateString = null;
        Matcher matcher = PATTERN_DATE.matcher(line.substring(0, maxLength));
        if (matcher.find()) {
            dateString = matcher.group();
        }
        return dateString;
    }

    public String findThreadName(String line) {
        int beginIndex = line.indexOf(PIPE);
        int endIndex = line.indexOf(PIPE, beginIndex + 1);
        if (this.isPipeSeparator(line)) {
            if (beginIndex != -1 && endIndex != -1) {
                return line.substring(beginIndex + PIPE.length(), endIndex);
            }
        } else {
            int firstSpaceIndex = line.indexOf(ONE_SPACE);
            int secondSpaceIndex = line.indexOf(ONE_SPACE, firstSpaceIndex + 1);
            int thirdSpaceIndex = line.indexOf(ONE_SPACE, secondSpaceIndex + 1);
            return line.substring(secondSpaceIndex + 1, thirdSpaceIndex);
        }
        return null;
    }

    private boolean isPipeSeparator(String line) {
        return line.substring(0, 35).contains(PIPE);
    }

    public Date findDate(String line) {
        return DateService.getInstance().parseDateTimeFromLine(line, this.simpleDateFormat, PATTERN_DATE, 35);
    }

    @Inject
    public SubstitutionTactic() {
    }
}

