/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.doc.module.substitution.launching;

import com.credibledoc.enricher.deriving.Deriving;
import com.credibledoc.enricher.line.LineProcessor;
import com.credibledoc.enricher.line.LineProcessorService;
import com.credibledoc.enricher.searchcommand.SearchCommand;
import com.credibledoc.enricher.transformer.Transformer;
import com.credibledoc.substitution.doc.module.substitution.launching.ConfigurationLoadingSearchCommand;
import com.credibledoc.substitution.doc.module.substitution.launching.ConfigurationLoadingTransformer;
import com.credibledoc.substitution.doc.module.substitution.launching.ContentReplacedSearchCommand;
import com.credibledoc.substitution.doc.module.substitution.launching.ContentReplacedTransformer;
import com.credibledoc.substitution.doc.module.substitution.launching.FinishedSearchCommand;
import com.credibledoc.substitution.doc.module.substitution.launching.FinishedTransformer;
import com.credibledoc.substitution.doc.module.substitution.launching.LaunchingSearchCommand;
import com.credibledoc.substitution.doc.module.substitution.launching.LaunchingTransformer;
import com.credibledoc.substitution.reporting.reportdocument.ReportDocument;
import com.credibledoc.substitution.reporting.reportdocument.ReportDocumentType;
import com.credibledoc.substitution.reporting.reportdocument.creator.ReportDocumentCreator;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import javax.inject.Inject;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class LaunchingUmlReportService
implements ReportDocumentCreator {
    private static final Logger log = LoggerFactory.getLogger(LaunchingUmlReportService.class);
    @NonNull
    private final ApplicationContext applicationContext;

    public ReportDocument prepareReportDocument() {
        ReportDocument reportDocument = new ReportDocument();
        reportDocument.setReportDocumentType(ReportDocumentType.DOCUMENT_PART_UML);
        ArrayList<LineProcessor> lineProcessors = new ArrayList<LineProcessor>();
        lineProcessors.add(new LineProcessor((SearchCommand)this.applicationContext.getBean(LaunchingSearchCommand.class), (Transformer)this.applicationContext.getBean(LaunchingTransformer.class), (Deriving)reportDocument));
        lineProcessors.add(new LineProcessor((SearchCommand)this.applicationContext.getBean(ConfigurationLoadingSearchCommand.class), (Transformer)this.applicationContext.getBean(ConfigurationLoadingTransformer.class), (Deriving)reportDocument));
        lineProcessors.add(new LineProcessor((SearchCommand)this.applicationContext.getBean(ContentReplacedSearchCommand.class), (Transformer)this.applicationContext.getBean(ContentReplacedTransformer.class), (Deriving)reportDocument));
        lineProcessors.add(new LineProcessor((SearchCommand)this.applicationContext.getBean(FinishedSearchCommand.class), (Transformer)this.applicationContext.getBean(FinishedTransformer.class), (Deriving)reportDocument));
        LineProcessorService.getInstance().getLineProcessors().addAll(lineProcessors);
        log.info("Line processors prepared");
        return reportDocument;
    }

    public ReportDocumentType getReportDocumentType() {
        return ReportDocumentType.DOCUMENT_PART_UML;
    }

    @ConstructorProperties(value={"applicationContext"})
    @Inject
    public LaunchingUmlReportService(@NonNull ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new NullPointerException("applicationContext");
        }
        this.applicationContext = applicationContext;
    }
}

