/*
 * Decompiled with CFR 0.152.
 */
package com.credibledoc.substitution.doc.module.substitution.file;

import com.credibledoc.combiner.application.Application;
import com.credibledoc.combiner.application.ApplicationService;
import com.credibledoc.combiner.file.FileService;
import com.credibledoc.combiner.node.applicationlog.ApplicationLog;
import com.credibledoc.combiner.node.file.NodeFileService;
import com.credibledoc.substitution.core.exception.SubstitutionRuntimeException;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FileUtilService {
    private static final Logger logger = LoggerFactory.getLogger(FileUtilService.class);
    private static final char DOT = '.';
    private static final String REPORT_FOLDER_EXTENSION = ".report";

    public File generateFile(Integer fileNumber, String fileName, File reportDirectory, String fileExtension) {
        String num = null;
        if (fileNumber != null) {
            num = String.format("%03d", fileNumber);
        }
        StringBuilder newFileName = new StringBuilder(fileName);
        if (num != null) {
            newFileName.append('.').append(num);
        }
        newFileName.append('.').append(fileExtension);
        File file = new File(reportDirectory, newFileName.toString());
        logger.info("The new empty file created: '{}'", (Object)file.getAbsolutePath());
        return file;
    }

    private void collectApplicationLogs(File directory, List<ApplicationLog> applicationLogs) {
        File[] files;
        Preconditions.checkNotNull((Object)directory);
        Preconditions.checkState((boolean)directory.isDirectory());
        HashMap map = new HashMap();
        for (File file : files = Objects.requireNonNull(directory.listFiles())) {
            this.addFileToMap(applicationLogs, map, files, file);
        }
        ApplicationService applicationService = ApplicationService.getInstance();
        for (Map.Entry appEntry : map.entrySet()) {
            Application application = (Application)appEntry.getKey();
            ApplicationLog applicationLog = applicationService.findOrCreate(applicationLogs, application);
            NodeFileService.getInstance().appendToNodeLogs((Map)appEntry.getValue(), applicationLog);
        }
    }

    private void addFileToMap(List<ApplicationLog> applicationLogs, Map<Application, Map<Date, File>> map, File[] files, File file) {
        if (file.isFile()) {
            Date date;
            Application application;
            if (file.getName().endsWith(".zip")) {
                file = this.unzipIfNotExists(file, files);
            }
            if (!map.containsKey(application = FileService.getInstance().findApplication(file))) {
                map.put(application, new TreeMap());
            }
            if ((date = FileService.getInstance().findDate(file, application)) == null) {
                throw new SubstitutionRuntimeException("Cannot find a date in the file: " + file.getAbsolutePath());
            }
            map.get(application).put(date, file);
        } else if (!file.getName().endsWith(REPORT_FOLDER_EXTENSION)) {
            this.collectApplicationLogs(file, applicationLogs);
        }
    }

    /*
     * Exception decompiling
     */
    private File unzipIfNotExists(File zipFile, File[] files) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 27[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Inject
    public FileUtilService() {
    }
}

