/*
 * Decompiled with CFR 0.152.
 */
package com.creativewidgetworks.expressionparser;

import com.creativewidgetworks.expressionparser.ValueType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Value {
    private String name;
    private ValueType type = ValueType.UNDEFINED;
    private Object valueObj = null;
    private String valueStr = "";
    private BigDecimal valueNum = BigDecimal.ZERO;
    private Date valueDate = null;
    private List<Value> array = null;

    public Value() {
    }

    public Value(String name) {
        this.name = name;
    }

    public Value(String name, Object var) {
        this(name);
        if (var instanceof String) {
            this.setValue((String)var);
        } else if (var instanceof BigDecimal) {
            this.setValue((BigDecimal)var);
        } else if (var instanceof Boolean) {
            this.setValue((Boolean)var);
        } else if (var instanceof Date) {
            this.setValue((Date)var);
        } else {
            this.setValue(var);
        }
    }

    public Value(Value var) {
        this.set(var);
    }

    public final Value clear() {
        this.type = ValueType.UNDEFINED;
        this.valueStr = "";
        this.valueNum = BigDecimal.ZERO;
        this.valueDate = null;
        this.valueObj = null;
        this.unsetArray();
        return this;
    }

    public final void set(Value var) {
        if (var != null) {
            this.name = var.name;
            this.type = var.type;
            this.valueObj = var.valueObj;
            this.valueStr = var.valueStr;
            this.valueNum = var.valueNum == null ? null : new BigDecimal(var.valueNum.toPlainString());
            Date date = this.valueDate = var.valueDate == null ? null : new Date(var.valueDate.getTime());
            if (var.array != null) {
                this.type = ValueType.ARRAY;
                this.array = new ArrayList<Value>(var.array.size());
                for (Value v : var.array) {
                    this.array.add(new Value(v));
                }
            } else {
                this.array = null;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ValueType getType() {
        return this.type;
    }

    public void setType(ValueType type) {
        this.type = type;
    }

    public void addValueToArray(Value value) {
        if (this.array == null) {
            this.array = new ArrayList<Value>();
        }
        this.array.add(value);
    }

    public List<Value> getArray() {
        return this.array;
    }

    public final void unsetArray() {
        if (this.array != null) {
            this.array.clear();
            this.array = null;
        }
    }

    public Boolean asBoolean() {
        return BigDecimal.ONE.equals(this.valueNum);
    }

    public Date asDate() {
        return this.valueDate;
    }

    public BigDecimal asNumber() {
        return this.valueNum;
    }

    public Object asObject() {
        return this.valueObj;
    }

    public String asString() {
        return this.valueStr;
    }

    public Value setValue(BigDecimal value) {
        this.valueObj = value;
        this.valueNum = value;
        this.valueStr = value == null ? null : value.toPlainString();
        this.valueDate = value == null ? null : new Date(value.longValue());
        this.setType(ValueType.NUMBER);
        return this;
    }

    public Value setValue(Boolean value) {
        this.valueObj = value;
        boolean val = value != null && value != false;
        this.valueStr = val ? "1" : "0";
        this.valueNum = val ? BigDecimal.ONE : BigDecimal.ZERO;
        this.valueDate = null;
        this.setType(ValueType.BOOLEAN);
        return this;
    }

    public Value setValue(Date value) {
        this.valueObj = value;
        this.valueDate = value;
        if (this.valueDate != null) {
            this.valueNum = new BigDecimal(this.valueDate.getTime());
            this.valueStr = this.valueDate.toString();
        } else {
            this.valueNum = null;
            this.valueStr = null;
        }
        this.setType(ValueType.DATE);
        return this;
    }

    public Value setValue(Object value) {
        this.valueObj = value;
        this.valueStr = value == null ? null : value.toString();
        this.valueNum = value != null && value instanceof BigDecimal ? (BigDecimal)value : null;
        this.valueDate = value != null && value instanceof Date ? (Date)value : null;
        this.setType(ValueType.OBJECT);
        return this;
    }

    public Value setValue(String value) {
        this.valueObj = value;
        this.valueStr = value;
        this.valueNum = BigDecimal.ZERO;
        this.valueDate = null;
        this.setType(ValueType.STRING);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=").append(this.name == null ? "n/a" : this.name).append(" type=");
        switch (this.type) {
            case BOOLEAN: {
                sb.append("BOOLEAN (");
                sb.append(this.asBoolean() != false ? "TRUE" : "FALSE");
                sb.append(")");
                break;
            }
            case NUMBER: 
            case OBJECT: 
            case STRING: 
            case DATE: {
                sb.append(this.type.name());
                break;
            }
            default: {
                sb.append("UNDEFINED");
            }
        }
        sb.append(" str=").append(this.valueStr);
        sb.append(" num=").append(this.valueNum);
        return sb.toString();
    }
}

