/*
 * Decompiled with CFR 0.152.
 */
package com.creativewidgetworks.expressionparser;

import com.creativewidgetworks.expressionparser.Operator;
import com.creativewidgetworks.expressionparser.Parser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

enum TokenType {
    COMMENT("/\\*[^*]*\\*+(?:[^*/][^*]*\\*+)*/", false),
    NUMBER("(?:\\b[0-9]+(?:\\.[0-9]*)?|\\.[0-9]+\\b)(?:[eE][-+]?[0-9]+\\b)?", false),
    STRING("\"((?:[^\"\\\\]|\\\\.)*)\"|'((?:[^'\\\\]|\\\\.)*)'", true),
    OPERATOR("~~dynamically-generated~~", false),
    CONSTANT("~~dynamically-generated~~", false),
    FUNCTION("~~dynamically-generated~~", false),
    IDENTIFIER("[_A-Za-z][_A-Za-z0-9]*", false),
    FIELD("@([@]{0,2}[\\.\\->_/:A-Za-z0-9]+)", true),
    PROPERTY("\\$\\{(.*)}", true),
    NEWLINE("\n", false),
    EOS(";", false),
    WHITESPACE("[ \\t]+", false),
    NOMATCH("", false),
    NOTHROW("", false),
    VALUE("", false);

    private final String regex;
    private final Pattern pattern;

    private TokenType(String regex, boolean resolutionNeeded) {
        this.regex = regex;
        this.pattern = resolutionNeeded ? Pattern.compile(regex) : null;
    }

    String getRegex(Parser parser) {
        if (this.equals((Object)OPERATOR)) {
            return Operator.getOperatorRegex();
        }
        if (this.equals((Object)CONSTANT)) {
            return parser.getConstantRegex();
        }
        if (this.equals((Object)FUNCTION)) {
            return parser.getFunctionRegex();
        }
        return this.regex;
    }

    public static String unescapeString(String str) {
        if (str == null || str.trim().length() == 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        block13: for (int i = 0; i < str.length(); ++i) {
            int ch = str.charAt(i);
            if (ch == 92) {
                String code;
                char nextChar;
                char c = nextChar = i == str.length() - 1 ? (char)'\\' : (char)str.charAt(i + 1);
                if (nextChar >= '0' && nextChar <= '7') {
                    code = "" + nextChar;
                    if (++i < str.length() - 1 && str.charAt(i + 1) >= '0' && str.charAt(i + 1) <= '7') {
                        code = code + str.charAt(i + 1);
                        if (++i < str.length() - 1 && str.charAt(i + 1) >= '0' && str.charAt(i + 1) <= '7') {
                            code = code + str.charAt(i + 1);
                            ++i;
                        }
                    }
                    sb.append(Character.toChars(Integer.parseInt(code, 8)));
                    continue;
                }
                switch (nextChar) {
                    case '\"': {
                        ch = 34;
                        break;
                    }
                    case '\'': {
                        ch = 39;
                        break;
                    }
                    case '\\': {
                        ch = 92;
                        break;
                    }
                    case 'f': {
                        ch = 12;
                        break;
                    }
                    case 'b': {
                        ch = 8;
                        break;
                    }
                    case 'n': {
                        ch = 10;
                        break;
                    }
                    case 'r': {
                        ch = 13;
                        break;
                    }
                    case 't': {
                        ch = 9;
                        break;
                    }
                    case 'u': {
                        if (i < str.length() - 5) {
                            try {
                                code = "" + str.charAt(i + 2) + str.charAt(i + 3) + str.charAt(i + 4) + str.charAt(i + 5);
                                sb.append(Character.toChars(Integer.parseInt(code, 16)));
                            }
                            catch (NumberFormatException ex) {
                                // empty catch block
                            }
                            i += 5;
                            continue block13;
                        }
                        ch = 117;
                        break;
                    }
                    default: {
                        --i;
                    }
                }
                ++i;
            }
            sb.append((char)ch);
        }
        return sb.toString();
    }

    String resolve(String text) {
        Matcher matcher;
        if (this.pattern != null && (matcher = this.pattern.matcher(text)).find() && matcher.groupCount() > 0) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (matcher.group(i) == null) continue;
                return TokenType.unescapeString(matcher.group(i));
            }
        }
        return text;
    }
}

