/*
 * Decompiled with CFR 0.152.
 */
package com.creativewidgetworks.expressionparser;

import com.creativewidgetworks.expressionparser.Function;
import com.creativewidgetworks.expressionparser.Parser;
import com.creativewidgetworks.expressionparser.ParserException;
import com.creativewidgetworks.expressionparser.Token;
import com.creativewidgetworks.expressionparser.TokenType;
import com.creativewidgetworks.expressionparser.Value;
import com.creativewidgetworks.expressionparser.ValueType;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class FunctionToolbox {
    private Parser parser;
    private static final Set<String> SET_TRUE = new HashSet<String>(Arrays.asList("1", "on", "t", "true", "y", "yes"));
    private static final Set<String> SET_FALSE = new HashSet<String>(Arrays.asList("0", "off", "f", "false", "n", "no"));
    private final Pattern pattern_NUMBER = Pattern.compile(TokenType.NUMBER.getRegex(new Parser()), 10);
    private final char MATCHBYLEN_VARIATIONS_SEPARATOR_CHARACTER = (char)58;
    private Parser tmpParser = null;
    public static final String[] DEFAULT_DATE_PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.S", "MMM dd yyyy hh:mm:ss.S a", "yyyy-MM-dd HH:mm:ss.S", "yyyyMMdd", "yyyy/MM/dd", "MM/dd/yyyy", "MMMM dd, yyyy", "MMM dd yyyy hh:mm:ss a", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "HH:mm:ss"};
    private String[] datePatterns = DEFAULT_DATE_PATTERNS;

    public static FunctionToolbox register(Parser parser) {
        FunctionToolbox toolbox = new FunctionToolbox();
        toolbox.parser = parser;
        parser.addFunction(new Function("ABS", toolbox, "_ABS", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("ARCCOS", toolbox, "_ARCCOS", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("ARCSIN", toolbox, "_ARCSIN", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("ARCTAN", toolbox, "_ARCTAN", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("ARRAYLEN", toolbox, "_ARRAYLEN", 1, 1, new ValueType[0]));
        parser.addFunction(new Function("AVERAGE", toolbox, "_AVERAGE", 1, Integer.MAX_VALUE, ValueType.NUMBER));
        parser.addFunction(new Function("CEILING", toolbox, "_CEILING", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("CONTAINS", toolbox, "_CONTAINS", 2, 2, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("CONTAINSALL", toolbox, "_CONTAINSALL", 2, 2, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("CONTAINSANY", toolbox, "_CONTAINSANY", 2, 2, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("COS", toolbox, "_COS", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("DATEADD", toolbox, "_DATEADD", 2, 3, ValueType.DATE, ValueType.NUMBER, ValueType.STRING));
        parser.addFunction(new Function("DATEBETWEEN", toolbox, "_DATEBETWEEN", 3, 3, ValueType.DATE, ValueType.DATE, ValueType.DATE));
        parser.addFunction(new Function("DATEBOD", toolbox, "_DATEBOD", 1, 1, ValueType.DATE));
        parser.addFunction(new Function("DATEEOD", toolbox, "_DATEEOD", 1, 1, ValueType.DATE));
        parser.addFunction(new Function("DATEFORMAT", toolbox, "_DATEFORMAT", 2, 8, ValueType.STRING, ValueType.UNDEFINED, ValueType.NUMBER, ValueType.NUMBER, ValueType.NUMBER, ValueType.NUMBER, ValueType.NUMBER));
        parser.addFunction(new Function("DATEWITHIN", toolbox, "_DATEWITHIN", 3, 3, ValueType.DATE, ValueType.DATE, ValueType.NUMBER));
        parser.addFunction(new Function("DIGITSONLY", toolbox, "_DIGITSONLY", 1, 1, ValueType.STRING));
        parser.addFunction(new Function("ENDSWITH", toolbox, "_ENDSWITH", 2, 2, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("EXP", toolbox, "_EXP", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("FACTORIAL", toolbox, "_FACTORIAL", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("FIND", toolbox, "_FIND", 2, 3, ValueType.STRING, ValueType.STRING, ValueType.NUMBER));
        parser.addFunction(new Function("FLOOR", toolbox, "_FLOOR", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("FORMAT", toolbox, "_FORMAT", 2, 2, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("FORMATBYLEN", toolbox, "_FORMATBYLEN", 3, 3, ValueType.STRING, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("GUID", toolbox, "_GUID", 0, 1, ValueType.NUMBER));
        parser.addFunction(new Function("HEX", toolbox, "_HEX", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("ISANYOF", toolbox, "_ISANYOF", 1, Integer.MAX_VALUE, ValueType.STRING, ValueType.UNDEFINED));
        parser.addFunction(new Function("ISBLANK", toolbox, "_ISBLANK", 1, 1, new ValueType[0]));
        parser.addFunction(new Function("ISBOOLEAN", toolbox, "_ISBOOLEAN", 1, 1, new ValueType[0]));
        parser.addFunction(new Function("ISDATE", toolbox, "_ISDATE", 1, 2, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("ISNONEOF", toolbox, "_ISNONEOF", 1, Integer.MAX_VALUE, ValueType.STRING, ValueType.UNDEFINED));
        parser.addFunction(new Function("ISNULL", toolbox, "_ISNULL", 1, 1, new ValueType[0]));
        parser.addFunction(new Function("ISNUMBER", toolbox, "_ISNUMBER", 1, 1, new ValueType[0]));
        parser.addFunction(new Function("LEFT", toolbox, "_LEFT", 2, 2, ValueType.STRING, ValueType.NUMBER));
        parser.addFunction(new Function("LEFTOF", toolbox, "_LEFTOF", 2, 2, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("LEN", toolbox, "_LEN", 1, 1, ValueType.STRING));
        parser.addFunction(new Function("LOG", toolbox, "_LOG", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("LOG10", toolbox, "_LOG10", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("LOWER", toolbox, "_LOWER", 1, 1, ValueType.STRING));
        parser.addFunction(new Function("MAKEBOOLEAN", toolbox, "_MAKEBOOLEAN", 1, 1, new ValueType[0]));
        parser.addFunction(new Function("MAKEDATE", toolbox, "_MAKEDATE", 1, 7, ValueType.UNDEFINED, ValueType.UNDEFINED, ValueType.NUMBER, ValueType.NUMBER, ValueType.NUMBER, ValueType.NUMBER, ValueType.NUMBER));
        parser.addFunction(new Function("MATCH", toolbox, "_MATCH", 2, 2, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("MAX", toolbox, "_MAX", 2, 2, ValueType.NUMBER, ValueType.NUMBER));
        parser.addFunction(new Function("MID", toolbox, "_MID", 2, 3, ValueType.STRING, ValueType.NUMBER, ValueType.NUMBER));
        parser.addFunction(new Function("MIN", toolbox, "_MIN", 2, 2, ValueType.NUMBER, ValueType.NUMBER));
        parser.addFunction(new Function("NAMECASE", toolbox, "_NAMECASE", 1, 1, ValueType.STRING));
        parser.addFunction(new Function("RANDOM", toolbox, "_RANDOM", 0, 2, ValueType.NUMBER, ValueType.NUMBER));
        parser.addFunction(new Function("REPLACE", toolbox, "_REPLACE", 3, 3, ValueType.STRING, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("REPLACEALL", toolbox, "_REPLACEALL", 3, 3, ValueType.STRING, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("REPLACEFIRST", toolbox, "_REPLACEFIRST", 3, 3, ValueType.STRING, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("RIGHT", toolbox, "_RIGHT", 2, 2, ValueType.STRING, ValueType.NUMBER));
        parser.addFunction(new Function("RIGHTOF", toolbox, "_RIGHTOF", 2, 2, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("ROUND", toolbox, "_ROUND", 2, 2, ValueType.NUMBER, ValueType.NUMBER));
        parser.addFunction(new Function("SIN", toolbox, "_SIN", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("SPLIT", toolbox, "_SPLIT", 1, 3, ValueType.STRING, ValueType.STRING, ValueType.NUMBER));
        parser.addFunction(new Function("SQR", toolbox, "_SQR", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("SQRT", toolbox, "_SQRT", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("STARTSWITH", toolbox, "_STARTSWITH", 2, 2, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("STR", toolbox, "_STR", 1, 3, ValueType.NUMBER, ValueType.NUMBER, ValueType.NUMBER));
        parser.addFunction(new Function("STRING", toolbox, "_STRING", 2, 2, ValueType.STRING, ValueType.NUMBER));
        parser.addFunction(new Function("TAN", toolbox, "_TAN", 1, 1, ValueType.NUMBER));
        parser.addFunction(new Function("TRIM", toolbox, "_TRIM", 1, 2, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("TRIMLEFT", toolbox, "_TRIMLEFT", 1, 2, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("TRIMRIGHT", toolbox, "_TRIMRIGHT", 1, 2, ValueType.STRING, ValueType.STRING));
        parser.addFunction(new Function("UPPER", toolbox, "_UPPER", 1, 1, ValueType.STRING));
        parser.addFunction(new Function("VAL", toolbox, "_VAL", 1, 1, ValueType.STRING));
        return toolbox;
    }

    private boolean isTrimableCharacter(char toTest, char testChar) {
        return toTest == testChar || testChar == ' ' && Character.isWhitespace(toTest);
    }

    private String makeString(char c, int len) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < len) {
            sb.append(c);
        }
        return sb.toString();
    }

    private double getNumber(long minimum, long maximum, int precision) {
        double result = minimum - 1L;
        double multiplier = 0.0;
        if (maximum < minimum) {
            long temp = minimum;
            minimum = maximum;
            maximum = temp;
        }
        precision = Math.abs(precision);
        result = (double)Math.min(minimum, maximum) + Math.floor(Math.random() * (double)Math.abs(maximum - minimum));
        multiplier = Math.pow(10.0, precision);
        int decimal = (int)(Math.random() * multiplier);
        return result += (double)decimal / multiplier;
    }

    protected BigDecimal scale(BigDecimal number) {
        BigDecimal result = number;
        if (number != null) {
            result = number.doubleValue() == 0.0 ? BigDecimal.ZERO : number.setScale(this.parser.getPrecision(), 4).stripTrailingZeros();
        }
        return result;
    }

    private String trimLeft(String str, char characterToRemove) {
        StringBuilder sb = new StringBuilder(str);
        if (str.length() > 0) {
            while (sb.length() > 0 && this.isTrimableCharacter(sb.charAt(0), characterToRemove)) {
                sb.deleteCharAt(0);
            }
        }
        return sb.toString();
    }

    private String trimRight(String str, char characterToRemove) {
        StringBuilder sb = new StringBuilder(str);
        int length = sb.length();
        while (length > 0 && this.isTrimableCharacter(sb.charAt(length - 1), characterToRemove)) {
            sb.deleteCharAt(length - 1);
            length = sb.length();
        }
        return sb.toString();
    }

    private String trim(String str, char characterToRemove) {
        String strToTrim = this.trimLeft(str, characterToRemove);
        return this.trimRight(strToTrim, characterToRemove);
    }

    public String[] getDatePatterns() {
        return this.datePatterns;
    }

    public String[] setDatePatterns(String[] datePatterns) {
        String[] orgDatePatterns = this.datePatterns;
        this.datePatterns = datePatterns;
        return orgDatePatterns;
    }

    public Value _ABS(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal number = stack.pop().asNumber();
        if (number != null) {
            double d = Math.abs(number.doubleValue());
            value.setValue(this.scale(BigDecimal.valueOf(d)));
        }
        return value;
    }

    public Value _ARCCOS(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal number = stack.pop().asNumber();
        if (number != null) {
            double d = Math.acos(number.doubleValue());
            value.setValue(this.scale(BigDecimal.valueOf(Math.toDegrees(d))));
        }
        return value;
    }

    public Value _ARCSIN(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal number = stack.pop().asNumber();
        if (number != null) {
            double d = Math.asin(number.doubleValue());
            value.setValue(this.scale(BigDecimal.valueOf(Math.toDegrees(d))));
        }
        return value;
    }

    public Value _ARCTAN(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal number = stack.pop().asNumber();
        if (number != null) {
            double d = Math.atan(number.doubleValue());
            value.setValue(this.scale(BigDecimal.valueOf(Math.toDegrees(d))));
        }
        return value;
    }

    public Value _ARRAYLEN(Token function, Stack<Token> stack) throws ParserException {
        Value value = new Value(function.getText()).setValue(BigDecimal.ZERO);
        Token token = stack.pop();
        Value theValue = token.getValue();
        if (theValue.asObject() != null) {
            if (theValue.getArray() == null) {
                String msg = ParserException.formatMessage("error.expected_array", new Object[]{token.getValue().getType()});
                throw new ParserException(msg, token.getRow(), token.getColumn());
            }
            value.setValue(BigDecimal.valueOf(theValue.getArray().size()));
        } else {
            value.setValue((BigDecimal)null);
        }
        return value;
    }

    public Value _AVERAGE(Token function, Stack<Token> stack) throws ParserException {
        String nullParams = this.parser.listOfNullParameters(stack, function.getArgc());
        if (nullParams != null) {
            throw new ParserException(ParserException.formatMessage("error.null_parameters", nullParams), function.getRow(), function.getColumn());
        }
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        Token[] args = this.parser.popArguments(function, stack);
        BigDecimal number = args[0].asNumber();
        if (number != null) {
            int count = 1;
            double d = number.doubleValue();
            for (int i = 1; i < function.getArgc(); ++i) {
                ++count;
                if (args[i].getValue().getType() == ValueType.NUMBER) {
                    number = args[i].asNumber();
                    d += number.doubleValue();
                    continue;
                }
                String msg = ParserException.formatMessage("error.expected_number", args[i].getValue().getType().name());
                throw new ParserException(msg, args[i].getRow(), args[i].getColumn());
            }
            value.setValue(this.scale(BigDecimal.valueOf(d / (double)count)));
        }
        return value;
    }

    public Value _CEILING(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal number = stack.pop().asNumber();
        if (number != null) {
            double d = Math.ceil(number.doubleValue());
            value.setValue(BigDecimal.valueOf(d));
        }
        return value;
    }

    public Value _CONTAINS(Token function, Stack<Token> stack) {
        String matchStr = stack.pop().asString();
        String str = stack.pop().asString();
        boolean b = false;
        if (str != null && matchStr != null) {
            b = str.contains(matchStr);
        }
        return new Value(function.getText()).setValue(b ? Boolean.TRUE : Boolean.FALSE);
    }

    public Value _CONTAINSALL(Token function, Stack<Token> stack) {
        String matchStr = stack.pop().asString();
        String str = stack.pop().asString();
        boolean b = false;
        if (str != null && matchStr != null) {
            b = str.length() > 0 && matchStr.length() > 0;
            for (int i = 0; i < matchStr.length(); ++i) {
                if (str.indexOf(matchStr.charAt(i)) != -1) continue;
                b = false;
                break;
            }
        }
        return new Value(function.getText()).setValue(b ? Boolean.TRUE : Boolean.FALSE);
    }

    public Value _CONTAINSANY(Token function, Stack<Token> stack) {
        String matchStr = stack.pop().asString();
        String str = stack.pop().asString();
        boolean b = false;
        if (str != null && matchStr != null) {
            for (int i = 0; i < matchStr.length(); ++i) {
                if (str.indexOf(matchStr.charAt(i)) == -1) continue;
                b = true;
                break;
            }
        }
        return new Value(function.getText()).setValue(b ? Boolean.TRUE : Boolean.FALSE);
    }

    public Value _COS(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal number = stack.pop().asNumber();
        if (number != null) {
            double radians = Math.toRadians(number.doubleValue());
            value.setValue(this.scale(BigDecimal.valueOf(Math.cos(radians))));
        }
        return value;
    }

    public Value _DATEADD(Token function, Stack<Token> stack) throws ParserException {
        int field;
        String nullParams = this.parser.listOfNullParameters(stack, function.getArgc());
        if (nullParams != null) {
            throw new ParserException(ParserException.formatMessage("error.null_parameters", nullParams), function.getRow(), function.getColumn());
        }
        String period = (function.getArgc() < 3 ? "d" : stack.pop().asString()).toLowerCase();
        int delta = stack.pop().asNumber().intValue();
        Date date = stack.pop().asDate();
        if (period.equals("m")) {
            field = 2;
        } else if (period.equals("d")) {
            field = 5;
        } else if (period.equals("y")) {
            field = 1;
        } else if (period.equals("hr")) {
            field = 10;
        } else if (period.equals("mi")) {
            field = 12;
        } else if (period.equals("se")) {
            field = 13;
        } else if (period.equals("ms")) {
            field = 14;
        } else {
            throw new ParserException(ParserException.formatMessage("error.expected_format_option", new Object[0]), function.getRow(), function.getColumn());
        }
        Calendar cal = Calendar.getInstance(this.parser.getTimeZone());
        cal.setTime(date);
        cal.add(field, delta);
        return new Value("DATEADD", cal.getTime());
    }

    public Value _DATEBETWEEN(Token function, Stack<Token> stack) {
        Date upper = stack.pop().asDate();
        Date lower = stack.pop().asDate();
        Date dateToTest = stack.pop().asDate();
        boolean inRange = upper != null && lower != null && dateToTest != null;
        inRange = inRange && dateToTest.getTime() >= lower.getTime() && dateToTest.getTime() <= upper.getTime();
        return new Value(function.getText()).setValue(inRange ? Boolean.TRUE : Boolean.FALSE);
    }

    public Value _DATEBOD(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText(), null);
        Date date = stack.pop().asDate();
        if (date != null) {
            Calendar cal = Calendar.getInstance(this.parser.getTimeZone());
            cal.setTime(date);
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            value.setValue(cal.getTime());
        }
        return value;
    }

    public Value _DATEEOD(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText(), null);
        Date date = stack.pop().asDate();
        if (date != null) {
            Calendar cal = Calendar.getInstance(this.parser.getTimeZone());
            cal.setTime(date);
            cal.set(cal.get(1), cal.get(2), cal.get(5), 23, 59, 59);
            value.setValue(cal.getTime());
        }
        return value;
    }

    public Value _DATEFORMAT(Token function, Stack<Token> stack) throws ParserException {
        String nullParams = this.parser.listOfNullParameters(stack, function.getArgc());
        if (nullParams != null) {
            throw new ParserException(ParserException.formatMessage("error.null_parameters", nullParams), function.getRow(), function.getColumn());
        }
        Value value = new Value(function.getText()).setValue((Date)null);
        Token[] args = this.parser.popArguments(function, stack);
        String formatString = args[0].asString();
        if (formatString != null) {
            Token func;
            Date date;
            Stack<Token> stk = new Stack<Token>();
            ValueType type = args[1].getValue().getType();
            if (ValueType.DATE.equals((Object)type)) {
                if (args.length > 2) {
                    throw new ParserException(ParserException.formatMessage("error.function_too_many_params", new Object[0]), args[2].getRow(), args[2].getColumn());
                }
                date = args[1].getValue().asDate();
            } else if (ValueType.STRING.equals((Object)type)) {
                if (args.length > 2) {
                    throw new ParserException(ParserException.formatMessage("error.function_too_many_params", new Object[0]), args[2].getRow(), args[2].getColumn());
                }
                stk.push(args[1]);
                func = new Token(function.getType(), function.getText(), function.getRow(), function.getColumn());
                func.setArgc(1);
                date = this._MAKEDATE(func, stk).asDate();
            } else if (ValueType.NUMBER.equals((Object)type)) {
                for (int i = 1; i < args.length; ++i) {
                    stk.push(args[i]);
                }
                func = new Token(function.getType(), function.getText(), function.getRow(), function.getColumn());
                func.setArgc(args.length - 1);
                date = this._MAKEDATE(func, stk).asDate();
            } else {
                throw new ParserException(ParserException.formatMessage("error.function_type_mismatch", function.getText(), String.valueOf(1), ValueType.NUMBER.name(), type.name()), args[1].getRow(), args[1].getColumn());
            }
            SimpleDateFormat sdf = new SimpleDateFormat(formatString);
            sdf.setTimeZone(this.parser.getTimeZone());
            if (date != null) {
                value.setValue(sdf.format(date));
            }
        }
        return value;
    }

    public Value _DATEWITHIN(Token function, Stack<Token> stack) {
        BigDecimal millis = stack.pop().asNumber();
        Date date2 = stack.pop().asDate();
        Date date1 = stack.pop().asDate();
        boolean within = millis != null && date2 != null && date1 != null;
        within = within && Math.abs(date1.getTime() - date2.getTime()) <= (long)millis.intValue();
        return new Value(function.getText()).setValue(within ? Boolean.TRUE : Boolean.FALSE);
    }

    public Value _DIGITSONLY(Token function, Stack<Token> stack) {
        String str = stack.pop().asString();
        StringBuilder sb = new StringBuilder();
        if (str != null) {
            for (int i = 0; i < str.length(); ++i) {
                if (!Character.isDigit(str.charAt(i))) continue;
                sb.append(str.charAt(i));
            }
        }
        return new Value(function.getText()).setValue(sb.toString());
    }

    public Value _ENDSWITH(Token function, Stack<Token> stack) {
        String match = stack.pop().asString();
        String str = stack.pop().asString();
        boolean b = str != null && match != null && str.endsWith(match);
        return new Value(function.getText()).setValue(b ? Boolean.TRUE : Boolean.FALSE);
    }

    public Value _EXP(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal number = stack.pop().asNumber();
        if (number != null) {
            int dp = this.parser.getPrecision();
            double d = Math.exp(number.doubleValue());
            BigDecimal bd = BigDecimal.valueOf(d).setScale(dp, 4);
            value.setValue(bd);
        }
        return value;
    }

    public Value _FACTORIAL(Token function, Stack<Token> stack) throws ParserException {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        Token numberToken = stack.pop();
        BigDecimal number = numberToken.asNumber();
        if (number != null) {
            if (number.intValue() < 0) {
                throw new ParserException(ParserException.formatMessage("error.function_value_negative", number), numberToken.getRow(), numberToken.getColumn());
            }
            BigDecimal bd = BigDecimal.ONE;
            int count = number.intValue();
            for (int i = 1; i <= count; ++i) {
                bd = bd.multiply(BigDecimal.valueOf(i));
            }
            value.setValue(bd);
        }
        return value;
    }

    public Value _FIND(Token function, Stack<Token> stack) {
        BigDecimal start;
        Value value = new Value(function.getText()).setValue(BigDecimal.ZERO);
        Token[] args = this.parser.popArguments(function, stack);
        String str = args[0].asString();
        String searchFor = args[1].asString();
        BigDecimal bigDecimal = start = function.getArgc() == 3 ? args[2].asNumber() : BigDecimal.ONE;
        if (str != null) {
            int startAt;
            if (searchFor == null || searchFor.length() == 0) {
                value.setValue(BigDecimal.ONE);
            } else if (str.length() > 0 && (startAt = start.intValue()) < str.length()) {
                BigDecimal bd = new BigDecimal(str.indexOf(searchFor, --startAt));
                value.setValue(bd.add(BigDecimal.ONE));
            }
        }
        return value;
    }

    public Value _FLOOR(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal number = stack.pop().asNumber();
        if (number != null) {
            double d = Math.floor(number.doubleValue());
            value.setValue(BigDecimal.valueOf(d));
        }
        return value;
    }

    public Value _FORMAT(Token function, Stack<Token> stack) throws ParserException {
        String nullParams = this.parser.listOfNullParameters(stack, function.getArgc());
        if (nullParams != null) {
            throw new ParserException(ParserException.formatMessage("error.null_parameters", nullParams), function.getRow(), function.getColumn());
        }
        String unformattedStr = stack.pop().asString();
        String mask = stack.pop().asString();
        int o = 0;
        StringBuilder sb = new StringBuilder(mask);
        for (int i = 0; i < sb.length() && o < unformattedStr.length(); ++i) {
            if (sb.charAt(i) != '#') continue;
            sb.setCharAt(i, unformattedStr.charAt(o++));
        }
        return new Value(function.getText()).setValue(sb.toString());
    }

    public Value _FORMATBYLEN(Token function, Stack<Token> stack) throws ParserException {
        Value value = new Value(function.getText()).setValue((String)null);
        if (this.tmpParser == null) {
            this.tmpParser = new Parser(this.parser);
        }
        HashMap<String, String> variations = new HashMap<String, String>();
        String variationsStr = stack.pop().asString();
        if (variationsStr != null && variationsStr.trim().length() > 0) {
            String[] rows;
            for (String row : rows = variationsStr.split(":")) {
                String[] fields = row.split("=");
                variations.put(fields[0], fields.length > 1 ? fields[1] : "");
            }
        }
        Token patternToken = stack.pop();
        String pattern = patternToken.asString();
        String str = stack.pop().asString();
        if (str != null && pattern != null && variations != null) {
            Pattern p = null;
            try {
                p = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException ex) {
                throw new ParserException(ParserException.formatMessage("error.invalid_regex_pattern", pattern), patternToken.getRow(), patternToken.getColumn());
            }
            Matcher m1 = p.matcher(str);
            if (m1.find()) {
                String key = String.valueOf(m1.group(0).length());
                String exp = (String)variations.get(key);
                if (exp != null) {
                    if (exp.indexOf("#") == -1) {
                        Value tmp = this.tmpParser.eval(exp.replace('\'', '\"'));
                        exp = tmp.asString();
                    }
                    int o = 0;
                    StringBuilder sb = new StringBuilder(exp);
                    for (int i = 0; i < sb.length() && o < m1.group(0).length(); ++i) {
                        if (sb.charAt(i) != '#') continue;
                        sb.setCharAt(i, m1.group(0).charAt(o++));
                    }
                    value.setValue(sb.toString());
                } else if (exp == null && key.equals("0")) {
                    value.setValue("");
                } else {
                    exp = (String)variations.get("?");
                    if (exp != null) {
                        Value tmp = this.tmpParser.eval(exp.replace('\'', '\"'));
                        value.setValue(tmp.asString());
                    } else {
                        value.setValue("");
                    }
                }
            } else {
                value.setValue("");
            }
        }
        return value;
    }

    public Value _GUID(Token function, Stack<Token> stack) {
        BigDecimal mode;
        String guid = UUID.randomUUID().toString();
        Token[] args = this.parser.popArguments(function, stack);
        BigDecimal bigDecimal = mode = args.length == 0 ? BigDecimal.ZERO : args[0].asNumber();
        if (mode != null) {
            int option = mode.intValue();
            if (option == 0 || option == 1) {
                guid = guid.replace("-", "");
            }
            if (option == 4 || option == 5) {
                guid = "{" + guid + "}";
            }
            if (option == 1 || option == 3 || option == 5) {
                guid = guid.toUpperCase();
            }
        }
        return new Value(function.getText()).setValue(guid);
    }

    public Value _HEX(Token function, Stack<Token> stack) {
        int byteMax = 256;
        int wordMax = 65536;
        int hexByteLen = 2;
        int hexWordLen = 4;
        int hexLongLen = 8;
        Value value = new Value(function.getText()).setValue((String)null);
        int l = 0;
        String str = "";
        BigDecimal number = stack.pop().asNumber();
        if (number != null) {
            long d = number.longValue();
            if (Math.abs(d) < 65536L) {
                l = Math.abs(d) < 256L ? 2 : 4;
                str = Integer.toHexString((int)d);
            } else {
                l = 8;
                str = Long.toHexString(d);
            }
            if (d < 0L) {
                str = str.substring(str.length() - l);
            } else {
                while (str.length() < l) {
                    str = "0" + str;
                }
            }
            value.setValue(str.toUpperCase());
        }
        return value;
    }

    public Value _ISANYOF(Token function, Stack<Token> stack) {
        Token[] args = this.parser.popArguments(function, stack);
        String text = args[0].asString();
        boolean found = false;
        if (text != null) {
            for (int i = 1; i < function.getArgc(); ++i) {
                if (!text.equals(args[i].asString())) continue;
                found = true;
                break;
            }
        }
        return new Value(function.getText()).setValue(found ? Boolean.TRUE : Boolean.FALSE);
    }

    public Value _ISBLANK(Token function, Stack<Token> stack) {
        String str = stack.pop().asString();
        return new Value(function.getText()).setValue(str == null || str.trim().length() == 0 ? Boolean.TRUE : Boolean.FALSE);
    }

    public Value _ISBOOLEAN(Token function, Stack<Token> stack) {
        Value value;
        value.setValue((value = this._MAKEBOOLEAN(function, stack)).asObject() != null && ValueType.BOOLEAN.equals((Object)value.getType()) ? Boolean.TRUE : Boolean.FALSE);
        return value;
    }

    public Value _ISDATE(Token function, Stack<Token> stack) {
        boolean validDate;
        try {
            Value value = this._MAKEDATE(function, stack);
            validDate = value.asDate() != null;
        }
        catch (ParserException ex) {
            validDate = false;
        }
        return new Value(function.getText()).setValue(validDate ? Boolean.TRUE : Boolean.FALSE);
    }

    public Value _ISNONEOF(Token function, Stack<Token> stack) {
        Value value = this._ISANYOF(function, stack);
        return new Value(function.getText()).setValue(value.asBoolean() != false ? Boolean.FALSE : Boolean.TRUE);
    }

    public Value _ISNULL(Token function, Stack<Token> stack) {
        String str = stack.pop().asString();
        return new Value(function.getText()).setValue(str == null ? Boolean.TRUE : Boolean.FALSE);
    }

    public Value _ISNUMBER(Token function, Stack<Token> stack) {
        String str = stack.pop().asString();
        boolean b = str != null && this.pattern_NUMBER.matcher(str).find();
        return new Value(function.getText()).setValue(b);
    }

    public Value _LEFT(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((String)null);
        BigDecimal bdCount = stack.pop().asNumber();
        String str = stack.pop().asString();
        if (str != null) {
            if (bdCount != null) {
                int count = bdCount.intValue();
                if (str.length() > 0 && count > 0) {
                    int sourceLen = str.length();
                    int targetLen = sourceLen > count ? count : sourceLen;
                    char[] buffer = new char[targetLen];
                    str.getChars(0, targetLen, buffer, 0);
                    value.setValue(new String(buffer));
                } else {
                    value.setValue("");
                }
            } else {
                value.setValue(str);
            }
        }
        return value;
    }

    public Value _LEFTOF(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((String)null);
        String toMatch = stack.pop().asString();
        String str = stack.pop().asString();
        if (str != null) {
            if (toMatch != null && str.indexOf(toMatch) > 0) {
                value.setValue(str.substring(0, str.indexOf(toMatch)));
            } else {
                value.setValue(str);
            }
        }
        return value;
    }

    public Value _LEN(Token function, Stack<Token> stack) {
        String str = stack.pop().asString();
        return new Value(function.getText()).setValue(BigDecimal.valueOf(str == null ? 0L : (long)str.length()));
    }

    public Value _LOG(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal number = stack.pop().asNumber();
        if (number != null) {
            double d = Math.log(number.doubleValue());
            value.setValue(BigDecimal.valueOf(d));
        }
        return value;
    }

    public Value _LOG10(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal number = stack.pop().asNumber();
        if (number != null) {
            double d = Math.log10(number.doubleValue());
            value.setValue(BigDecimal.valueOf(d));
        }
        return value;
    }

    public Value _LOWER(Token function, Stack<Token> stack) {
        String str = stack.pop().asString();
        return new Value(function.getText()).setValue(str == null ? null : str.toLowerCase());
    }

    public Value _MAKEBOOLEAN(Token function, Stack<Token> stack) {
        String str;
        Value value = new Value(function.getText()).setValue((Boolean)null);
        Token token = stack.pop();
        if (token.asString() != null && token.getValue().getType() != ValueType.DATE && (str = token.asString()) != null) {
            if (SET_TRUE.contains(str = str.toLowerCase())) {
                value.setValue(Boolean.TRUE);
            } else if (SET_FALSE.contains(str)) {
                value.setValue(Boolean.FALSE);
            } else if (this.pattern_NUMBER.matcher(str).find()) {
                BigDecimal bd = new BigDecimal(str);
                if (bd.compareTo(BigDecimal.ZERO) == 0) {
                    value.setValue(Boolean.FALSE);
                } else if (bd.compareTo(BigDecimal.ONE) == 0) {
                    value.setValue(Boolean.TRUE);
                }
            }
        }
        return value;
    }

    public Value _MAKEDATE(Token function, Stack<Token> stack) throws ParserException {
        Value value = new Value(function.getText()).setValue((Date)null);
        Token[] args = this.parser.popArguments(function, stack);
        String[] patterns = this.getDatePatterns();
        if (ValueType.STRING == args[0].getValue().getType()) {
            if (args.length > 1) {
                if (ValueType.STRING != args[1].getValue().getType()) {
                    throw new ParserException(ParserException.formatMessage("error.type_mismatch_generic", new Object[]{"STRING", args[1].getValue().getType()}), args[1].getRow(), args[1].getColumn());
                }
                if (args.length > 2) {
                    throw new ParserException(ParserException.formatMessage("error.function_parameter_count", "MAKEDATE", "1..2", String.valueOf(args.length)), args[1].getRow(), args[1].getColumn());
                }
                if (args[1].asString() == null || args[1].asString().trim().length() == 0) {
                    throw new ParserException(ParserException.formatMessage("error.empty", "format string"), args[1].getRow(), args[1].getColumn());
                }
                patterns = new String[]{args[1].asString()};
            }
            for (String pattern : patterns) {
                SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                sdf.setLenient(false);
                sdf.setTimeZone(this.parser.getTimeZone());
                try {
                    value.setValue(sdf.parse(args[0].asString()));
                    break;
                }
                catch (Exception ex) {
                }
            }
        } else {
            int ms;
            int sec;
            int min;
            int hour;
            int year;
            int day;
            int mon;
            try {
                mon = args[0].asNumber().intValue() - 1;
                day = args[1].asNumber().intValue();
                year = args[2].asNumber().intValue();
                hour = args.length > 3 ? args[3].asNumber().intValue() : 0;
                min = args.length > 4 ? args[4].asNumber().intValue() : 0;
                sec = args.length > 5 ? args[5].asNumber().intValue() : 0;
                ms = args.length > 6 ? args[6].asNumber().intValue() : 0;
            }
            catch (Exception ex) {
                return value;
            }
            if (year < 100) {
                year = year > 50 ? (year += 1900) : (year += 2000);
            }
            Calendar cal = Calendar.getInstance(this.parser.getTimeZone());
            cal.setLenient(false);
            try {
                cal.set(year, mon, day, hour, min, sec);
                cal.set(14, ms);
                value.setValue(cal.getTime());
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                String[] fields = new String[]{"MONTH", "DAY_OF_MONTH", "YEAR", "HOUR_OF_DAY", "MINUTE", "SECOND"};
                int row = function.getRow();
                int col = function.getColumn();
                for (int i = 0; i < fields.length; ++i) {
                    if (!fields[i].equals(msg)) continue;
                    row = args[i].getRow();
                    col = args[i].getColumn();
                    break;
                }
                throw new ParserException(ParserException.formatMessage("error", "Invalid value " + msg), row, col);
            }
        }
        return value;
    }

    public Value _MATCH(Token function, Stack<Token> stack) throws ParserException {
        Value value = new Value(function.getText()).setValue((String)null);
        Token patternToken = stack.pop();
        String pattern = patternToken.asString();
        String str = stack.pop().asString();
        if (str != null && pattern != null) {
            Pattern p = null;
            try {
                p = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException ex) {
                throw new ParserException(ParserException.formatMessage("error.invalid_regex_pattern", pattern), patternToken.getRow(), patternToken.getColumn());
            }
            Matcher m1 = p.matcher(str);
            if (m1.find()) {
                for (int i = 0; i <= m1.groupCount(); ++i) {
                    String matchGroup;
                    String string = matchGroup = m1.group(i) == null ? "" : m1.group(i);
                    if (i == 0) {
                        value.setValue(matchGroup);
                    }
                    Value aValue = new Value("match" + i).setValue(matchGroup);
                    value.addValueToArray(aValue);
                }
            } else {
                value.setValue("");
            }
        }
        value.setType(ValueType.ARRAY);
        return value;
    }

    public Value _MAX(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal rhs = stack.pop().asNumber();
        BigDecimal lhs = stack.pop().asNumber();
        if (lhs != null && rhs != null) {
            value.setValue(lhs.max(rhs));
        }
        return value;
    }

    public Value _MID(Token function, Stack<Token> stack) {
        BigDecimal length;
        Value value = new Value(function.getText()).setValue((String)null);
        Token[] args = this.parser.popArguments(function, stack);
        String str = args[0].asString();
        BigDecimal index = args[1].asNumber();
        BigDecimal bigDecimal = length = args.length == 2 ? null : args[2].asNumber();
        if (str != null && index != null && (args.length < 3 || length != null)) {
            if (str.length() > 0) {
                int count;
                int start = index.intValue();
                int n = count = function.getArgc() == 2 ? str.length() : length.intValue();
                if (start < 1 || count <= 0 || start > str.length()) {
                    value.setValue("");
                } else {
                    int len = str.length();
                    int end = start + count > len ? len : start - 1 + count;
                    value.setValue(str.substring(start - 1, end));
                }
            } else {
                value.setValue("");
            }
        }
        return value;
    }

    public Value _MIN(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal rhs = stack.pop().asNumber();
        BigDecimal lhs = stack.pop().asNumber();
        if (lhs != null && rhs != null) {
            value.setValue(lhs.min(rhs));
        }
        return value;
    }

    public Value _NAMECASE(Token function, Stack<Token> stack) {
        String str = stack.pop().asString();
        if (str != null) {
            StringBuilder sb = new StringBuilder();
            boolean uc = true;
            for (int i = 0; i < str.length(); ++i) {
                if (uc && !Character.isWhitespace(str.charAt(i))) {
                    sb.append(Character.toUpperCase(str.charAt(i)));
                    uc = false;
                    continue;
                }
                sb.append(Character.toLowerCase(str.charAt(i)));
                if (!Character.isWhitespace(str.charAt(i))) continue;
                uc = true;
            }
            str = sb.toString();
        }
        return new Value(function.getText()).setValue(str);
    }

    public Value _RANDOM(Token function, Stack<Token> stack) throws ParserException {
        String nullParams = this.parser.listOfNullParameters(stack, function.getArgc());
        if (nullParams != null) {
            throw new ParserException(ParserException.formatMessage("error.null_parameters", nullParams), function.getRow(), function.getColumn());
        }
        Token[] args = this.parser.popArguments(function, stack);
        double d = 0.0;
        if (args.length == 0) {
            d = this.getNumber(0L, 1L, this.parser.getPrecision());
        } else if (args.length == 1) {
            d = this.getNumber(0L, args[0].asNumber().longValue(), this.parser.getPrecision());
        } else if (args.length == 2) {
            d = this.getNumber(args[0].asNumber().longValue(), args[1].asNumber().longValue(), this.parser.getPrecision());
        }
        return new Value(function.getText()).setValue(BigDecimal.valueOf(d));
    }

    public Value _REPLACE(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((String)null);
        String replaceWith = stack.pop().asString();
        String searchFor = stack.pop().asString();
        String str = stack.pop().asString();
        if (str != null) {
            if (searchFor == null || replaceWith == null) {
                value.setValue(str);
            } else {
                value.setValue(str.replace(searchFor, replaceWith));
            }
        }
        return value;
    }

    public Value _REPLACEALL(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((String)null);
        String replaceWith = stack.pop().asString();
        String searchFor = stack.pop().asString();
        String str = stack.pop().asString();
        if (str != null) {
            if (searchFor == null || replaceWith == null) {
                value.setValue(str);
            } else {
                value.setValue(str.replaceAll(searchFor, replaceWith));
            }
        }
        return value;
    }

    public Value _REPLACEFIRST(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((String)null);
        String replaceWith = stack.pop().asString();
        String searchFor = stack.pop().asString();
        String str = stack.pop().asString();
        if (str != null) {
            if (searchFor == null || replaceWith == null) {
                value.setValue(str);
            } else {
                value.setValue(str.replaceFirst(searchFor, replaceWith));
            }
        }
        return value;
    }

    public Value _RIGHT(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((String)null);
        BigDecimal bdCount = stack.pop().asNumber();
        String str = stack.pop().asString();
        if (str != null) {
            if (bdCount != null) {
                int count = bdCount.intValue();
                if (str.length() > 0 && count > 0) {
                    int sourceLen = str.length();
                    int targetLen = sourceLen > count ? count : sourceLen;
                    char[] buffer = new char[targetLen];
                    str.getChars(sourceLen - targetLen, sourceLen, buffer, 0);
                    value.setValue(new String(buffer));
                } else {
                    value.setValue("");
                }
            } else {
                value.setValue(str);
            }
        }
        return value;
    }

    public Value _RIGHTOF(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((String)null);
        String toMatch = stack.pop().asString();
        String str = stack.pop().asString();
        if (str != null) {
            if (toMatch != null && str.indexOf(toMatch) != -1) {
                int offset = str.indexOf(toMatch) + toMatch.length();
                value.setValue(str.substring(offset));
            } else {
                value.setValue("");
            }
        }
        return value;
    }

    public Value _ROUND(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal places = stack.pop().asNumber();
        BigDecimal number = stack.pop().asNumber();
        if (number != null && places != null) {
            value.setValue(number.setScale(places.intValue(), 4));
        }
        return value;
    }

    public Value _SIN(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal number = stack.pop().asNumber();
        if (number != null) {
            double radians = Math.toRadians(number.doubleValue());
            value.setValue(this.scale(BigDecimal.valueOf(Math.sin(radians))));
        }
        return value;
    }

    public Value _SPLIT(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((String)null);
        Token[] args = this.parser.popArguments(function, stack);
        if (args[0].asString() != null) {
            String delimiter = args.length > 1 && args[1].asString() != null ? args[1].asString() : ",";
            int limit = args.length == 3 && args[2].asNumber() != null ? args[2].asNumber().intValue() : -1;
            String[] fields = args[0].asString().split(delimiter, limit);
            if (fields.length > 0) {
                value.setValue(fields[0]);
                for (int i = 0; i < fields.length; ++i) {
                    Value aValue = new Value(function.getText() + i).setValue(fields[i]);
                    value.addValueToArray(aValue);
                }
            }
        }
        return value;
    }

    public Value _SQR(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal number = stack.pop().asNumber();
        if (number != null) {
            double d = number.doubleValue() * number.doubleValue();
            value.setValue(this.scale(BigDecimal.valueOf(d)));
        }
        return value;
    }

    public Value _SQRT(Token function, Stack<Token> stack) throws ParserException {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        Token token = stack.pop();
        BigDecimal number = token.asNumber();
        if (number != null) {
            double d = Math.sqrt(number.doubleValue());
            if (Double.isNaN(d)) {
                String msg = ParserException.formatMessage("error.not_a_number", new Object[0]);
                throw new ParserException(msg, token.getRow(), token.getColumn());
            }
            value.setValue(this.scale(BigDecimal.valueOf(d)));
        }
        return value;
    }

    public Value _STARTSWITH(Token function, Stack<Token> stack) {
        String match = stack.pop().asString();
        String str = stack.pop().asString();
        boolean b = str != null && match != null && str.startsWith(match);
        return new Value(function.getText()).setValue(b ? Boolean.TRUE : Boolean.FALSE);
    }

    public Value _STR(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((String)null);
        Token[] args = this.parser.popArguments(function, stack);
        String number = args[0].asString();
        if (number != null) {
            boolean done = false;
            BigDecimal precision = null;
            BigDecimal width = null;
            if (function.getArgc() > 1) {
                width = args[1].asNumber();
                if (width == null) {
                    done = true;
                } else if (function.getArgc() > 2 && (precision = args[2].asNumber()) == null) {
                    done = true;
                }
            }
            if (!done) {
                if (function.getArgc() > 1) {
                    int dp;
                    StringBuilder sb = new StringBuilder();
                    int tl = width.intValue();
                    int len = tl - (dp = precision == null ? 0 : precision.intValue()) - 1;
                    if (len > 0) {
                        sb.append(this.makeString('#', len - 1));
                        sb.append('0');
                    }
                    if (dp > 0) {
                        sb.append(".");
                        sb.append(this.makeString('0', dp));
                    }
                    DecimalFormat df = new DecimalFormat(sb.toString());
                    BigDecimal bd = new BigDecimal(number).setScale(dp, 4);
                    value.setValue(df.format(bd));
                } else {
                    value.setValue(number);
                }
            }
        }
        return value;
    }

    public Value _STRING(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((String)null);
        BigDecimal count = stack.pop().asNumber();
        String str = stack.pop().asString();
        if (str != null && count != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < count.intValue(); ++i) {
                sb.append(str);
            }
            value.setValue(sb.toString());
        }
        return value;
    }

    public Value _TAN(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((BigDecimal)null);
        BigDecimal number = stack.pop().asNumber();
        if (number != null) {
            double radians = Math.toRadians(number.doubleValue());
            value.setValue(this.scale(BigDecimal.valueOf(Math.tan(radians))));
        }
        return value;
    }

    public Value _TRIM(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((String)null);
        Token[] args = this.parser.popArguments(function, stack);
        String str = args[0].asString();
        if (str != null) {
            if (function.getArgc() == 2 && args[1].asString() != null && args[1].asString().length() > 0) {
                value.setValue(this.trim(str, args[1].asString().charAt(0)));
            } else {
                value.setValue(str.trim());
            }
        }
        return value;
    }

    public Value _TRIMLEFT(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((String)null);
        Token[] args = this.parser.popArguments(function, stack);
        String str = args[0].asString();
        if (str != null) {
            if (function.getArgc() == 2 && args[1].asString() != null && args[1].asString().length() > 0) {
                value.setValue(this.trimLeft(str, args[1].asString().charAt(0)));
            } else {
                value.setValue(this.trimLeft(str, ' '));
            }
        }
        return value;
    }

    public Value _TRIMRIGHT(Token function, Stack<Token> stack) {
        Value value = new Value(function.getText()).setValue((String)null);
        Token[] args = this.parser.popArguments(function, stack);
        String str = args[0].asString();
        if (str != null) {
            if (function.getArgc() == 2 && args[1].asString() != null && args[1].asString().length() > 0) {
                value.setValue(this.trimRight(str, args[1].asString().charAt(0)));
            } else {
                value.setValue(this.trimRight(str, ' '));
            }
        }
        return value;
    }

    public Value _UPPER(Token function, Stack<Token> stack) {
        String str = stack.pop().asString();
        return new Value(function.getText()).setValue(str == null ? null : str.toUpperCase());
    }

    public Value _VAL(Token function, Stack<Token> stack) throws ParserException {
        Token token = stack.pop();
        try {
            String str = token.asString();
            BigDecimal bd = str == null ? null : (str.length() == 0 ? BigDecimal.ZERO : new BigDecimal(str));
            return new Value(function.getText()).setValue(bd);
        }
        catch (NumberFormatException nfe) {
            throw new ParserException(ParserException.formatMessage("error.expected_numberformat", token.asString()), token.getRow(), token.getColumn());
        }
    }
}

