/*
 * Decompiled with CFR 0.152.
 */
import com.creativewidgetworks.expressionparser.FunctionToolbox;
import com.creativewidgetworks.expressionparser.Parser;
import com.creativewidgetworks.expressionparser.ParserException;
import com.creativewidgetworks.expressionparser.Token;
import com.creativewidgetworks.expressionparser.Value;
import java.util.List;

public class Demo {
    private static void usage() {
        System.out.println();
        System.out.println("usage: Demo \"expression\" [-verbose]");
    }

    public static void main(String[] args) throws ParserException {
        boolean verbose = false;
        String expression = null;
        if (args.length == 0) {
            Demo.usage();
            return;
        }
        expression = args[0];
        verbose = args.length > 1 && args[1].toLowerCase().startsWith("-v");
        DemoParser parser = new Demo().new DemoParser();
        FunctionToolbox.register(parser);
        Value value = parser.eval(expression);
        System.out.println();
        System.out.println("EVALUATING " + expression);
        if (verbose) {
            System.out.println();
            List<Token> tokens = parser.getInfix();
            System.out.println("INPUT (INFIX)");
            for (Token token : tokens) {
                System.out.println(token);
            }
            System.out.println();
            List<Token> rpn = parser.getPostfix();
            System.out.println("RPN (POSTFIX)");
            for (Token token : rpn) {
                System.out.println(token);
            }
            System.out.println();
        }
        System.out.print("RESULT: ");
        if (value != null) {
            switch (value.getType()) {
                case BOOLEAN: {
                    System.out.println(value.asBoolean() + " [boolean]");
                    break;
                }
                case DATE: {
                    System.out.println(value.asDate() + " [date]");
                    break;
                }
                case STRING: {
                    System.out.println(value.asString() + " [string]");
                    break;
                }
                case NUMBER: {
                    System.out.println(value.asNumber() + " [number]");
                    break;
                }
                case UNDEFINED: {
                    System.out.println("undefined");
                }
            }
        }
    }

    class DemoParser
    extends Parser {
        private List<Token> infix;
        private List<Token> rpn;

        DemoParser() {
        }

        List<Token> getInfix() {
            return this.infix;
        }

        List<Token> getPostfix() {
            return this.rpn;
        }

        @Override
        public List<Token> infixToRPN(List<Token> inputTokens) throws ParserException {
            this.infix = inputTokens;
            this.rpn = super.infixToRPN(inputTokens);
            return this.rpn;
        }
    }
}

