/*
 * Decompiled with CFR 0.152.
 */
package com.celites.datautils;

import com.ceelites.devutils.ConstantMethods;
import com.celites.datautils.Column;
import com.celites.datautils.NoColumnsException;
import java.util.ArrayList;

public class Table {
    private String name;
    private boolean addIfNotExist;
    private ArrayList<Column> columns;

    private Table(String name, boolean addIfNotExists) {
        this.name = name;
        this.addIfNotExist = addIfNotExists;
        this.columns = new ArrayList();
    }

    public static Table createTable(String name, boolean addIfNotExists) {
        return new Table(name, addIfNotExists);
    }

    public Table addColumn(Column column) {
        this.columns.add(column);
        return this;
    }

    public Table addColumns(Column ... columnArray) {
        for (Column column : columnArray) {
            this.columns.add(column);
        }
        return this;
    }

    public String getGenerateTableQuery() throws NoColumnsException {
        if (ConstantMethods.isArrayListEmpty(this.columns)) {
            throw new NoColumnsException("Table " + this.name + " must have atleast one column");
        }
        StringBuilder query = new StringBuilder(" CREATE TABLE ");
        if (this.addIfNotExist) {
            query.append("IF NOT EXISTS ");
        }
        query.append("(");
        String columnDefinitions = "";
        for (Column column : this.columns) {
            columnDefinitions = ConstantMethods.addToCommaSeparatedString(columnDefinitions, column.getColumnDefinition(), false);
        }
        query.append(columnDefinitions).append(")");
        return query.toString();
    }
}

