/*
 * Decompiled with CFR 0.152.
 */
package com.ceelites.devutils;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;

public class SharedPreferenceUtils {
    private static SharedPreferenceUtils sharedPreferenceUtils;
    private SharedPreferences sharedPreferences;

    public static SharedPreferenceUtils initWith(SharedPreferences sharedPreferences) {
        if (sharedPreferenceUtils == null) {
            sharedPreferenceUtils = new SharedPreferenceUtils();
        }
        SharedPreferenceUtils.sharedPreferenceUtils.sharedPreferences = sharedPreferences;
        return sharedPreferenceUtils;
    }

    public static SharedPreferenceUtils initWith(Context context) {
        if (sharedPreferenceUtils == null) {
            sharedPreferenceUtils = new SharedPreferenceUtils();
        }
        SharedPreferenceUtils.sharedPreferenceUtils.sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return sharedPreferenceUtils;
    }

    public void put(String key, Object value) {
        if (value.getClass().equals(String.class)) {
            this.putString(key, value.toString());
        } else if (value.getClass().equals(Integer.class)) {
            this.putInt(key, (Integer)value);
        } else if (value.getClass().equals(Float.class)) {
            this.putFloat(key, ((Float)value).floatValue());
        } else if (value.getClass().equals(Long.class)) {
            this.putLong(key, (Long)value);
        } else if (value.getClass().equals(Boolean.class)) {
            this.putBoolean(key, (Boolean)value);
        } else {
            this.putString(key, value.toString());
        }
    }

    public void putInt(String key, int value) {
        this.sharedPreferences.edit().putInt(key, value).commit();
    }

    public int getInt(String key, int defaultValue) {
        return this.sharedPreferences.getInt(key, defaultValue);
    }

    public void putString(String key, String value) {
        this.sharedPreferences.edit().putString(key, value).commit();
    }

    public String getString(String key, String defaultValue) {
        return this.sharedPreferences.getString(key, defaultValue == null ? "" : defaultValue);
    }

    public void putBoolean(String key, boolean value) {
        this.sharedPreferences.edit().putBoolean(key, value).commit();
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.sharedPreferences.getBoolean(key, defaultValue);
    }

    public void putLong(String key, long value) {
        this.sharedPreferences.edit().putLong(key, value).commit();
    }

    public long getLong(String key, long defaultValue) {
        return this.sharedPreferences.getLong(key, defaultValue);
    }

    public void putFloat(String key, float value) {
        this.sharedPreferences.edit().putFloat(key, value).commit();
    }

    public float getFloat(String key, float defaultValue) {
        return this.sharedPreferences.getFloat(key, defaultValue);
    }

    public static int getNumber(CharSequence string) {
        int number = 0;
        if (!SharedPreferenceUtils.isEmptyString(string) && TextUtils.isDigitsOnly((CharSequence)string)) {
            number = Integer.parseInt(string.toString());
        }
        return number;
    }

    public static float getNumberFloat(CharSequence string) {
        float number = 0.0f;
        if (!SharedPreferenceUtils.isEmptyString(string) && TextUtils.isDigitsOnly((CharSequence)string)) {
            number = Float.parseFloat(string.toString());
        }
        return number;
    }

    public static long getNumberLong(CharSequence string) {
        long number = 0L;
        if (!SharedPreferenceUtils.isEmptyString(string) && TextUtils.isDigitsOnly((CharSequence)string)) {
            number = Long.parseLong(string.toString());
        }
        return number;
    }

    public static boolean isEmptyString(CharSequence string) {
        return TextUtils.isEmpty((CharSequence)string) || string.toString().equalsIgnoreCase("null");
    }

    public boolean isValueExistForKey(String key) {
        boolean isValueExists;
        try {
            String string = this.getString(key, "");
            isValueExists = !string.equalsIgnoreCase("");
        }
        catch (ClassCastException e) {
            try {
                int anInt = this.getInt(key, 0);
                isValueExists = anInt != 0;
            }
            catch (ClassCastException e1) {
                try {
                    long aLong = this.getLong(key, 0L);
                    isValueExists = aLong != 0L;
                }
                catch (ClassCastException e2) {
                    try {
                        float aFloat = this.getFloat(key, 0.0f);
                        isValueExists = aFloat != 0.0f;
                    }
                    catch (ClassCastException e3) {
                        try {
                            boolean aBoolean = this.getBoolean(key, false);
                            isValueExists = !aBoolean;
                        }
                        catch (Exception e4) {
                            isValueExists = false;
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            isValueExists = false;
        }
        return isValueExists;
    }

    public Object get(String key) {
        try {
            return this.getString(key, null);
        }
        catch (ClassCastException e) {
            try {
                return this.getInt(key, 0);
            }
            catch (ClassCastException e1) {
                try {
                    return this.getLong(key, 0L);
                }
                catch (ClassCastException e2) {
                    try {
                        return Float.valueOf(this.getFloat(key, 0.0f));
                    }
                    catch (ClassCastException e3) {
                        try {
                            return this.getBoolean(key, false);
                        }
                        catch (Exception e4) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                }
            }
        }
    }

    public void clear(String key) {
        this.sharedPreferences.edit().remove(key).commit();
    }
}

