/*
 * Decompiled with CFR 0.152.
 */
package com.createsend.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Configuration {
    public static Configuration Current = new Configuration();
    private Properties properties = new Properties();

    private Configuration() {
        try {
            InputStream configProperties = this.getClass().getClassLoader().getResourceAsStream("com/createsend/util/config.properties");
            if (configProperties == null) {
                throw new FileNotFoundException("Could not find config.properties");
            }
            this.properties.load(configProperties);
            InputStream createsendProperties = this.getClass().getClassLoader().getResourceAsStream("createsend.properties");
            if (createsendProperties != null) {
                this.properties.load(createsendProperties);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addPropertiesFile(String filename) throws IOException {
        this.properties.load(ClassLoader.getSystemResourceAsStream(filename));
    }

    public String getApiEndpoint() {
        return this.properties.getProperty("createsend.endpoint");
    }

    public String getOAuthBaseUri() {
        return this.properties.getProperty("createsend.oauthbaseuri");
    }

    public String getWrapperVersion() {
        return this.properties.getProperty("createsend.version");
    }

    public boolean isLoggingEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty("createsend.logging"));
    }
}

