/*
 * Decompiled with CFR 0.152.
 */
package com.createsend;

import com.createsend.CreateSendBase;
import com.createsend.models.PagedResult;
import com.createsend.models.lists.CustomField;
import com.createsend.models.lists.CustomFieldForCreate;
import com.createsend.models.lists.CustomFieldForUpdate;
import com.createsend.models.lists.List;
import com.createsend.models.lists.ListForUpdate;
import com.createsend.models.lists.Statistics;
import com.createsend.models.lists.UpdateFieldOptions;
import com.createsend.models.lists.Webhook;
import com.createsend.models.lists.WebhookTestFailureDetails;
import com.createsend.models.segments.Segment;
import com.createsend.models.subscribers.Subscriber;
import com.createsend.util.AuthenticationDetails;
import com.createsend.util.ErrorDeserialiser;
import com.createsend.util.JerseyClientImpl;
import com.createsend.util.exceptions.CreateSendException;
import com.createsend.util.jersey.JsonProvider;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.Date;
import javax.ws.rs.core.MultivaluedMap;

public class Lists
extends CreateSendBase {
    private String listID;

    public Lists(AuthenticationDetails auth) {
        this(auth, null);
    }

    public Lists(AuthenticationDetails auth, String listID) {
        this.setListID(listID);
        this.jerseyClient = new JerseyClientImpl(auth);
    }

    public void setListID(String listID) {
        this.listID = listID;
    }

    public String getListID() {
        return this.listID;
    }

    public String create(String clientID, List list) throws CreateSendException {
        this.listID = this.jerseyClient.post(String.class, (Object)list, "lists", clientID + ".json");
        return this.listID;
    }

    public void update(ListForUpdate list) throws CreateSendException {
        this.jerseyClient.put((Object)list, "lists", this.listID + ".json");
    }

    public void delete() throws CreateSendException {
        this.jerseyClient.delete("lists", this.listID + ".json");
    }

    public List details() throws CreateSendException {
        return this.jerseyClient.get(List.class, "lists", this.listID + ".json");
    }

    public Statistics stats() throws CreateSendException {
        return this.jerseyClient.get(Statistics.class, "lists", this.listID, "stats.json");
    }

    public CustomField[] customFields() throws CreateSendException {
        return this.jerseyClient.get(CustomField[].class, "lists", this.listID, "customfields.json");
    }

    public Segment[] segments() throws CreateSendException {
        return this.jerseyClient.get(Segment[].class, "lists", this.listID, "segments.json");
    }

    public PagedResult<Subscriber> active() throws CreateSendException {
        return this.active(1, (Integer)1000, "email", "asc", false);
    }

    public PagedResult<Subscriber> active(boolean includeTrackingPreference) throws CreateSendException {
        return this.active(1, (Integer)1000, "email", "asc", includeTrackingPreference);
    }

    public PagedResult<Subscriber> active(Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.active("", page, pageSize, orderField, orderDirection, false);
    }

    public PagedResult<Subscriber> active(Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        return this.active("", page, pageSize, orderField, orderDirection, includeTrackingPreference);
    }

    public PagedResult<Subscriber> active(Date subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.active(JsonProvider.ApiDateFormat.format(subscribedFrom), page, pageSize, orderField, orderDirection, false);
    }

    public PagedResult<Subscriber> active(Date subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        return this.active(JsonProvider.ApiDateFormat.format(subscribedFrom), page, pageSize, orderField, orderDirection, includeTrackingPreference);
    }

    private PagedResult<Subscriber> active(String subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"date", (Object)subscribedFrom);
        queryString.add((Object)"includetrackingpreference", (Object)String.valueOf(includeTrackingPreference));
        return this.jerseyClient.getPagedResult(page, pageSize, orderField, orderDirection, (MultivaluedMap<String, String>)queryString, "lists", this.listID, "active.json");
    }

    public PagedResult<Subscriber> unconfirmed() throws CreateSendException {
        return this.unconfirmed(1, (Integer)1000, "email", "asc", false);
    }

    public PagedResult<Subscriber> unconfirmed(boolean includeTrackingPreference) throws CreateSendException {
        return this.unconfirmed(1, (Integer)1000, "email", "asc", includeTrackingPreference);
    }

    public PagedResult<Subscriber> unconfirmed(Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.unconfirmed("", page, pageSize, orderField, orderDirection, false);
    }

    public PagedResult<Subscriber> unconfirmed(Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        return this.unconfirmed("", page, pageSize, orderField, orderDirection, includeTrackingPreference);
    }

    public PagedResult<Subscriber> unconfirmed(Date subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.unconfirmed(JsonProvider.ApiDateFormat.format(subscribedFrom), page, pageSize, orderField, orderDirection, false);
    }

    public PagedResult<Subscriber> unconfirmed(Date subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        return this.unconfirmed(JsonProvider.ApiDateFormat.format(subscribedFrom), page, pageSize, orderField, orderDirection, includeTrackingPreference);
    }

    private PagedResult<Subscriber> unconfirmed(String subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"date", (Object)subscribedFrom);
        queryString.add((Object)"includetrackingpreference", (Object)String.valueOf(includeTrackingPreference));
        return this.jerseyClient.getPagedResult(page, pageSize, orderField, orderDirection, (MultivaluedMap<String, String>)queryString, "lists", this.listID, "unconfirmed.json");
    }

    public PagedResult<Subscriber> unsubscribed() throws CreateSendException {
        return this.unsubscribed(1, (Integer)1000, "email", "asc", false);
    }

    public PagedResult<Subscriber> unsubscribed(boolean includeTrackingPreference) throws CreateSendException {
        return this.unsubscribed(1, (Integer)1000, "email", "asc", includeTrackingPreference);
    }

    public PagedResult<Subscriber> unsubscribed(Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.unsubscribed("", page, pageSize, orderField, orderDirection, false);
    }

    public PagedResult<Subscriber> unsubscribed(Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        return this.unsubscribed("", page, pageSize, orderField, orderDirection, includeTrackingPreference);
    }

    public PagedResult<Subscriber> unsubscribed(Date subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.unsubscribed(JsonProvider.ApiDateFormat.format(subscribedFrom), page, pageSize, orderField, orderDirection, false);
    }

    public PagedResult<Subscriber> unsubscribed(Date subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        return this.unsubscribed(JsonProvider.ApiDateFormat.format(subscribedFrom), page, pageSize, orderField, orderDirection, includeTrackingPreference);
    }

    private PagedResult<Subscriber> unsubscribed(String subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"date", (Object)subscribedFrom);
        queryString.add((Object)"includetrackingpreference", (Object)String.valueOf(includeTrackingPreference));
        return this.jerseyClient.getPagedResult(page, pageSize, orderField, orderDirection, (MultivaluedMap<String, String>)queryString, "lists", this.listID, "unsubscribed.json");
    }

    public PagedResult<Subscriber> deleted() throws CreateSendException {
        return this.deleted(1, (Integer)1000, "email", "asc", false);
    }

    public PagedResult<Subscriber> deleted(boolean includeTrackingPreference) throws CreateSendException {
        return this.deleted(1, (Integer)1000, "email", "asc", includeTrackingPreference);
    }

    public PagedResult<Subscriber> deleted(Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.deleted("", page, pageSize, orderField, orderDirection, false);
    }

    public PagedResult<Subscriber> deleted(Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        return this.deleted("", page, pageSize, orderField, orderDirection, includeTrackingPreference);
    }

    public PagedResult<Subscriber> deleted(Date subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.deleted(JsonProvider.ApiDateFormat.format(subscribedFrom), page, pageSize, orderField, orderDirection, false);
    }

    public PagedResult<Subscriber> deleted(Date subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        return this.deleted(JsonProvider.ApiDateFormat.format(subscribedFrom), page, pageSize, orderField, orderDirection, includeTrackingPreference);
    }

    private PagedResult<Subscriber> deleted(String subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"date", (Object)subscribedFrom);
        queryString.add((Object)"includetrackingpreference", (Object)String.valueOf(includeTrackingPreference));
        return this.jerseyClient.getPagedResult(page, pageSize, orderField, orderDirection, (MultivaluedMap<String, String>)queryString, "lists", this.listID, "deleted.json");
    }

    public PagedResult<Subscriber> bounced() throws CreateSendException {
        return this.bounced(1, (Integer)1000, "email", "asc", false);
    }

    public PagedResult<Subscriber> bounced(boolean includeTrackingPreference) throws CreateSendException {
        return this.bounced(1, (Integer)1000, "email", "asc", includeTrackingPreference);
    }

    public PagedResult<Subscriber> bounced(Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.bounced("", page, pageSize, orderField, orderDirection, false);
    }

    public PagedResult<Subscriber> bounced(Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        return this.bounced("", page, pageSize, orderField, orderDirection, includeTrackingPreference);
    }

    public PagedResult<Subscriber> bounced(Date subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.bounced(JsonProvider.ApiDateFormat.format(subscribedFrom), page, pageSize, orderField, orderDirection, false);
    }

    public PagedResult<Subscriber> bounced(Date subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        return this.bounced(JsonProvider.ApiDateFormat.format(subscribedFrom), page, pageSize, orderField, orderDirection, includeTrackingPreference);
    }

    private PagedResult<Subscriber> bounced(String subscribedFrom, Integer page, Integer pageSize, String orderField, String orderDirection, boolean includeTrackingPreference) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"date", (Object)subscribedFrom);
        queryString.add((Object)"includetrackingpreference", (Object)String.valueOf(includeTrackingPreference));
        return this.jerseyClient.getPagedResult(page, pageSize, orderField, orderDirection, (MultivaluedMap<String, String>)queryString, "lists", this.listID, "bounced.json");
    }

    public String createCustomField(CustomFieldForCreate customField) throws CreateSendException {
        return this.jerseyClient.post(String.class, (Object)customField, "lists", this.listID, "customfields.json");
    }

    public String updateCustomField(String fieldKey, CustomFieldForUpdate customField) throws CreateSendException {
        return this.jerseyClient.put(String.class, customField, "lists", this.listID, "customfields", fieldKey + ".json");
    }

    public void updateCustomFieldOptions(String fieldKey, UpdateFieldOptions options) throws CreateSendException {
        this.jerseyClient.put((Object)options, "lists", this.listID, "customFields", fieldKey, "options.json");
    }

    public void deleteCustomField(String fieldKey) throws CreateSendException {
        this.jerseyClient.delete("lists", this.listID, "customFields", fieldKey + ".json");
    }

    public Webhook[] webhooks() throws CreateSendException {
        return this.jerseyClient.get(Webhook[].class, "lists", this.listID, "webhooks.json");
    }

    public String createWebhook(Webhook webhook) throws CreateSendException {
        return this.jerseyClient.post(String.class, (Object)webhook, "lists", this.listID, "webhooks.json");
    }

    public void testWebhook(String webhookID) throws CreateSendException {
        this.jerseyClient.get(String.class, new ErrorDeserialiser<WebhookTestFailureDetails>(){}, "lists", this.listID, "webhooks", webhookID, "test.json");
    }

    public void deleteWebhook(String webhookID) throws CreateSendException {
        this.jerseyClient.delete("lists", this.listID, "webhooks", webhookID + ".json");
    }

    public void activateWebhook(String webhookID) throws CreateSendException {
        this.jerseyClient.put((Object)"", "lists", this.listID, "webhooks", webhookID, "activate.json");
    }

    public void deactivateWebhook(String webhookID) throws CreateSendException {
        this.jerseyClient.put((Object)"", "lists", this.listID, "webhooks", webhookID, "deactivate.json");
    }
}

