/*
 * Decompiled with CFR 0.152.
 */
package com.createsend;

import com.createsend.CreateSendBase;
import com.createsend.models.PagedResult;
import com.createsend.models.campaigns.DraftCampaign;
import com.createsend.models.campaigns.ScheduledCampaign;
import com.createsend.models.campaigns.SentCampaign;
import com.createsend.models.clients.AllClientDetails;
import com.createsend.models.clients.BillingDetails;
import com.createsend.models.clients.Client;
import com.createsend.models.clients.CreditsTransferDetails;
import com.createsend.models.clients.CreditsTransferResult;
import com.createsend.models.clients.SuppressionDetails;
import com.createsend.models.clients.Template;
import com.createsend.models.journeys.JourneyDetail;
import com.createsend.models.lists.ListBasics;
import com.createsend.models.lists.ListForEmail;
import com.createsend.models.people.Person;
import com.createsend.models.people.PersonResult;
import com.createsend.models.segments.Segment;
import com.createsend.models.subscribers.SuppressedSubscriber;
import com.createsend.util.AuthenticationDetails;
import com.createsend.util.JerseyClientImpl;
import com.createsend.util.exceptions.CreateSendException;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MultivaluedMap;

public class Clients
extends CreateSendBase {
    private String clientID;

    public Clients(AuthenticationDetails auth) {
        this(auth, null);
    }

    public Clients(AuthenticationDetails auth, String clientID) {
        this.setClientID(clientID);
        this.jerseyClient = new JerseyClientImpl(auth);
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String create(Client client) throws CreateSendException {
        this.clientID = this.jerseyClient.post(String.class, (Object)client, "clients.json");
        return this.clientID;
    }

    public AllClientDetails details() throws CreateSendException {
        return this.jerseyClient.get(AllClientDetails.class, "clients", this.clientID + ".json");
    }

    public SentCampaign[] sentCampaigns() throws CreateSendException {
        return this.jerseyClient.get(SentCampaign[].class, "clients", this.clientID, "campaigns.json");
    }

    public ScheduledCampaign[] scheduledCampaigns() throws CreateSendException {
        return this.jerseyClient.get(ScheduledCampaign[].class, "clients", this.clientID, "scheduled.json");
    }

    public DraftCampaign[] draftCampaigns() throws CreateSendException {
        return this.jerseyClient.get(DraftCampaign[].class, "clients", this.clientID, "drafts.json");
    }

    public ListBasics[] lists() throws CreateSendException {
        return this.jerseyClient.get(ListBasics[].class, "clients", this.clientID, "lists.json");
    }

    public ListForEmail[] listsForEmailAddress(String emailAddress) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"email", (Object)emailAddress);
        return this.jerseyClient.get(ListForEmail[].class, (MultivaluedMap<String, String>)queryString, "clients", this.clientID, "listsforemail.json");
    }

    public Segment[] segments() throws CreateSendException {
        return this.jerseyClient.get(Segment[].class, "clients", this.clientID, "segments.json");
    }

    public PagedResult<SuppressedSubscriber> suppressionList(Integer page, Integer pageSize, String orderField, String orderDirection) throws CreateSendException {
        return this.jerseyClient.getPagedResult(page, pageSize, orderField, orderDirection, null, "clients", this.clientID, "suppressionlist.json");
    }

    public void suppress(SuppressionDetails details) throws CreateSendException {
        this.jerseyClient.post(String.class, (Object)details, "clients", this.clientID, "suppress.json");
    }

    public void unsuppress(String email) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"email", (Object)email);
        this.jerseyClient.put((Object)"", (MultivaluedMap<String, String>)queryString, "clients", this.clientID, "unsuppress.json");
    }

    public Template[] templates() throws CreateSendException {
        return this.jerseyClient.get(Template[].class, "clients", this.clientID, "templates.json");
    }

    public void setBasics(Client client) throws CreateSendException {
        this.jerseyClient.put((Object)client, "clients", this.clientID, "setbasics.json");
    }

    public void setPaygBilling(BillingDetails billing) throws CreateSendException {
        this.jerseyClient.put((Object)billing, "clients", this.clientID, "setpaygbilling.json");
    }

    public void setMonthlyBilling(BillingDetails billing) throws CreateSendException {
        billing.MarkupOnDelivery = null;
        billing.MarkupOnDesignSpamTest = null;
        billing.MarkupPerRecipient = null;
        billing.CanPurchaseCredits = false;
        this.jerseyClient.put((Object)billing, "clients", this.clientID, "setmonthlybilling.json");
    }

    public CreditsTransferResult transferCredits(CreditsTransferDetails details) throws CreateSendException {
        return this.jerseyClient.post(CreditsTransferResult.class, (Object)details, "clients", this.clientID, "credits.json");
    }

    public void delete() throws CreateSendException {
        this.jerseyClient.delete("clients", this.clientID + ".json");
    }

    public Person[] people() throws CreateSendException {
        return this.jerseyClient.get(Person[].class, "clients", this.clientID, "people.json");
    }

    public String getPrimaryContact() throws CreateSendException {
        return this.jerseyClient.get(PersonResult.class, (String[])new String[]{"clients", this.clientID, "primarycontact.json"}).EmailAddress;
    }

    public void setPrimaryContact(String emailAddress) throws CreateSendException {
        MultivaluedMapImpl queryString = new MultivaluedMapImpl();
        queryString.add((Object)"email", (Object)emailAddress);
        this.jerseyClient.put((Object)"", (MultivaluedMap<String, String>)queryString, "clients", this.clientID, "primarycontact.json");
    }

    public JourneyDetail[] journeys() throws CreateSendException {
        return this.jerseyClient.get(JourneyDetail[].class, "clients", this.clientID, "journeys.json");
    }
}

