/*
 * Decompiled with CFR 0.152.
 */
package com.crazyhitty.chdev.ks.rssmanager;

import android.support.annotation.NonNull;
import android.util.Log;
import com.crazyhitty.chdev.ks.rssmanager.RSS;
import com.crazyhitty.chdev.ks.rssmanager.RssParser;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.simpleframework.xml.core.Persister;

public class RssReader {
    private static final String TAG = "RssReader";
    @NonNull
    private RssCallback rssCallback;
    private Disposable disposable;

    public RssReader(@NonNull RssCallback rssCallback) {
        this.rssCallback = rssCallback;
    }

    public void loadFeeds(String ... urls) {
        final long startTimeMillis = System.currentTimeMillis();
        ArrayList<Observable> observables = new ArrayList<Observable>();
        for (final String url : urls) {
            observables.add(Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<RSS>(){

                public void subscribe(ObservableEmitter<RSS> emitter) throws Exception {
                    block2: {
                        try {
                            RSS rss = (RSS)new Persister().read(RSS.class, RssParser.parse(url).body().string());
                            Log.d((String)RssReader.TAG, (String)("subscribe: url: " + url + " ; thread: " + Thread.currentThread().getName()));
                            emitter.onNext((Object)rss);
                            emitter.onComplete();
                        }
                        catch (InterruptedIOException e) {
                            if (emitter.isDisposed()) break block2;
                            emitter.onError((Throwable)e);
                        }
                    }
                }
            }));
        }
        Observable rssListObservable = Observable.zip(observables, (Function)new Function<Object[], List<RSS>>(){

            public List<RSS> apply(Object[] objects) throws Exception {
                ArrayList<RSS> rssList = new ArrayList<RSS>();
                for (Object object : objects) {
                    rssList.add((RSS)object);
                }
                return rssList;
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
        this.disposable = (Disposable)rssListObservable.subscribeWith((Observer)new DisposableObserver<List<RSS>>(){

            public void onNext(List<RSS> rssList) {
                RssReader.this.rssCallback.rssFeedsLoaded(rssList);
                Log.d((String)RssReader.TAG, (String)("onNext: rssListSize: " + rssList.size()));
            }

            public void onError(Throwable e) {
                RssReader.this.rssCallback.unableToReadRssFeeds(e.getMessage());
                Log.e((String)RssReader.TAG, (String)("onError: " + e.getMessage()), (Throwable)e);
            }

            public void onComplete() {
                Log.d((String)RssReader.TAG, (String)String.format(Locale.ENGLISH, "onComplete: done with time spent(ms): %d", System.currentTimeMillis() - startTimeMillis));
            }
        });
    }

    public void destroy() {
        this.disposable.dispose();
    }

    public static interface RssCallback {
        public void rssFeedsLoaded(List<RSS> var1);

        public void unableToReadRssFeeds(String var1);
    }
}

