/*
 * Decompiled with CFR 0.152.
 */
package com.crazyhitty.chdev.ks.rssmanager;

import android.content.Context;
import android.content.DialogInterface;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.crazyhitty.chdev.ks.rssmanager.OnFeedLoadListener;
import com.crazyhitty.chdev.ks.rssmanager.OnRssLoadListener;
import com.crazyhitty.chdev.ks.rssmanager.R;
import com.crazyhitty.chdev.ks.rssmanager.RssItem;
import com.crazyhitty.chdev.ks.rssmanager.RssParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class RssReader
implements OnFeedLoadListener {
    private String[] mUrlList;
    private String[] mSourceList;
    private String[] mCategories;
    private int[] mCategoryImgIds;
    private boolean mShowDialog = true;
    private Context mContext;
    private List<RssItem> mRssItems = new ArrayList<RssItem>();
    private RssParser mRssParser;
    private int mPosition = 0;
    private MaterialDialog mMaterialDialog;
    private OnRssLoadListener mOnRssLoadListener;

    @Deprecated
    public RssReader(Context context, String[] urlList, String[] sourceList, String[] categories, int[] categoryImgIds, OnRssLoadListener onRssLoadListener) {
        this.mContext = context;
        this.mUrlList = urlList;
        this.mSourceList = sourceList;
        this.mCategories = categories;
        this.mCategoryImgIds = categoryImgIds;
        this.mOnRssLoadListener = onRssLoadListener;
    }

    public RssReader(Context context) {
        this.mContext = context;
    }

    public RssReader urls(String[] urls) {
        this.mUrlList = urls;
        return this;
    }

    public RssReader sources(String[] sources) {
        this.mSourceList = sources;
        return this;
    }

    public RssReader categories(String[] categories) {
        this.mCategories = categories;
        return this;
    }

    @Deprecated
    public RssReader categoryImgIds(int[] categoryImgIds) {
        this.mCategoryImgIds = categoryImgIds;
        return this;
    }

    public RssReader showDialog(boolean status) {
        this.mShowDialog = status;
        return this;
    }

    public void parse(OnRssLoadListener onRssLoadListener) {
        this.mOnRssLoadListener = onRssLoadListener;
        if (this.mShowDialog) {
            this.initDialog();
        }
        if (this.mRssItems != null) {
            this.mRssItems.clear();
        }
        if (this.mUrlList == null) {
            throw new NullPointerException("Url list cannot be empty");
        }
        this.parseRss(0);
    }

    private void initDialog() {
        this.mMaterialDialog = new MaterialDialog.Builder(this.mContext).title(R.string.loading_feeds).progress(true, 0).progressIndeterminateStyle(true).cancelable(false).negativeText(R.string.cancel).onNegative(new MaterialDialog.SingleButtonCallback(){

            public void onClick(MaterialDialog materialDialog, DialogAction dialogAction) {
                if (RssReader.this.mRssParser != null) {
                    RssReader.this.mRssParser.cancel(true);
                }
                RssReader.this.mOnRssLoadListener.onFailure("User performed dismiss action");
            }
        }).build();
        this.mMaterialDialog.show();
        this.mMaterialDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                if (RssReader.this.mRssParser != null) {
                    RssReader.this.mRssParser.cancel(true);
                }
                RssReader.this.mOnRssLoadListener.onFailure("User performed dismiss action");
            }
        });
    }

    @Deprecated
    public void readRssFeeds() {
        this.initDialog();
        if (this.mRssItems != null) {
            this.mRssItems.clear();
        }
        this.parseRss(0);
    }

    private void parseRss(int position) {
        if (position != this.mUrlList.length) {
            this.mRssParser = new RssParser(this.mUrlList[position], this);
            this.mRssParser.execute(new String[0]);
            String source = this.getWebsiteName(this.mUrlList[position]);
            if (this.mMaterialDialog != null) {
                this.mMaterialDialog.setContent((CharSequence)source);
            }
        } else {
            if (this.mMaterialDialog != null) {
                this.mMaterialDialog.dismiss();
            }
            this.mOnRssLoadListener.onSuccess(this.mRssItems);
        }
    }

    private String getWebsiteName(String url) {
        try {
            URI uri = new URI(url);
            return uri.getHost();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return url;
        }
    }

    @Override
    public void onSuccess(Elements items) {
        for (Element item : items) {
            this.mRssItems.add(this.getRssItem(item));
        }
        ++this.mPosition;
        this.parseRss(this.mPosition);
    }

    @Override
    public void onFailure(String message) {
        this.mOnRssLoadListener.onFailure(message);
    }

    private RssItem getRssItem(Element element) {
        String title = element.select("title").first().text();
        String description = element.select("description").first().text();
        String link = element.select("link").first().text();
        String sourceName = null;
        if (this.mSourceList != null) {
            sourceName = this.mSourceList[this.mPosition];
        }
        String sourceUrl = this.mUrlList[this.mPosition];
        String sourceUrlShort = this.getWebsiteName(this.mUrlList[this.mPosition]);
        String imageUrl = !element.select("media|thumbnail").isEmpty() ? element.select("media|thumbnail").attr("url") : (!element.select("media|content").isEmpty() ? element.select("media|content").attr("url") : (!element.select("image").isEmpty() ? element.select("image").attr("url") : null));
        String category = null;
        if (this.mCategories == null) {
            try {
                category = element.select("category").first().text();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        } else {
            category = this.mCategories[this.mPosition];
        }
        String pubDate = element.select("pubDate").first().text();
        RssItem rssItem = new RssItem();
        rssItem.setTitle(title);
        rssItem.setDescription(description);
        rssItem.setLink(link);
        rssItem.setSourceName(sourceName);
        rssItem.setSourceUrl(sourceUrl);
        rssItem.setSourceUrlShort(sourceUrlShort);
        rssItem.setImageUrl(imageUrl);
        rssItem.setCategory(category);
        rssItem.setPubDate(pubDate);
        return rssItem;
    }
}

