/*
 * Decompiled with CFR 0.152.
 */
package com.crashlogger.android;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import com.crashlogger.android.IPostTask;
import com.crashlogger.android.model.DeviceInfo;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\f\u001a\u00020\nH\u0002J\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/crashlogger/android/CrashLogger;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "formattedInfoString", "", "deviceInfo", "Lcom/crashlogger/android/model/DeviceInfo;", "getAvailableInternalMemory", "", "getDeviceInformation", "getTotalInternalMemory", "uncaughtException", "", "t", "Ljava/lang/Thread;", "exception", "", "Companion", "app_release"})
public final class CrashLogger
implements Thread.UncaughtExceptionHandler {
    private final Context context;
    private static String userName;
    private static String userID;
    private static String userEmail;
    @Nullable
    private static final String TAG;
    private static volatile CrashLogger INSTANCE;
    public static final Companion Companion;

    private final long getAvailableInternalMemory() {
        File path;
        File file = path = Environment.getDataDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"path");
        StatFs stat = new StatFs(file.getPath());
        long blockSize = Build.VERSION.SDK_INT >= 18 ? stat.getBlockSizeLong() : (long)stat.getBlockSize();
        long availableBlocks = Build.VERSION.SDK_INT >= 18 ? stat.getAvailableBlocksLong() : (long)stat.getBlockSize();
        return availableBlocks * blockSize;
    }

    private final long getTotalInternalMemory() {
        File path;
        File file = path = Environment.getDataDirectory();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"path");
        StatFs stat = new StatFs(file.getPath());
        long blockSize = Build.VERSION.SDK_INT >= 18 ? stat.getBlockSizeLong() : (long)stat.getBlockSize();
        long totalBlocks = Build.VERSION.SDK_INT >= 18 ? stat.getBlockCountLong() : (long)stat.getBlockCount();
        return totalBlocks * blockSize;
    }

    private final DeviceInfo getDeviceInformation(Context context) {
        DeviceInfo deviceInfo;
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(context.getPackageName(), 0);
            Intrinsics.checkExpressionValueIsNotNull((Object)packageInfo, (String)"pm.getPackageInfo(context.packageName, 0)");
            PackageInfo pi = packageInfo;
            String string = pi.versionName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pi.versionName");
            String string2 = pi.packageName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"pi.packageName");
            File file = context.getFilesDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.filesDir");
            String string3 = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"context.filesDir.absolutePath");
            String string4 = Build.MODEL;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"Build.MODEL");
            String string5 = Build.VERSION.RELEASE;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"Build.VERSION.RELEASE");
            String string6 = Build.BOARD;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"Build.BOARD");
            String string7 = Build.BRAND;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"Build.BRAND");
            String string8 = Build.DEVICE;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"Build.DEVICE");
            String string9 = Build.DISPLAY;
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"Build.DISPLAY");
            String string10 = Build.FINGERPRINT;
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"Build.FINGERPRINT");
            String string11 = Build.HOST;
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"Build.HOST");
            String string12 = Build.ID;
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"Build.ID");
            String string13 = Build.MANUFACTURER;
            Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"Build.MANUFACTURER");
            String string14 = Build.MODEL;
            Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"Build.MODEL");
            String string15 = Build.PRODUCT;
            Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"Build.PRODUCT");
            String string16 = Build.TAGS;
            Intrinsics.checkExpressionValueIsNotNull((Object)string16, (String)"Build.TAGS");
            String string17 = Build.TYPE;
            Intrinsics.checkExpressionValueIsNotNull((Object)string17, (String)"Build.TYPE");
            String string18 = Build.USER;
            Intrinsics.checkExpressionValueIsNotNull((Object)string18, (String)"Build.USER");
            deviceInfo = new DeviceInfo(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, Build.TIME, string17, Build.VERSION.SDK_INT, string18);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)e.getMessage());
            deviceInfo = null;
        }
        return deviceInfo;
    }

    private final String formattedInfoString(DeviceInfo deviceInfo) {
        DeviceInfo deviceInfo2 = deviceInfo;
        DeviceInfo deviceInfo3 = deviceInfo;
        DeviceInfo deviceInfo4 = deviceInfo;
        DeviceInfo deviceInfo5 = deviceInfo;
        DeviceInfo deviceInfo6 = deviceInfo;
        DeviceInfo deviceInfo7 = deviceInfo;
        DeviceInfo deviceInfo8 = deviceInfo;
        DeviceInfo deviceInfo9 = deviceInfo;
        DeviceInfo deviceInfo10 = deviceInfo;
        DeviceInfo deviceInfo11 = deviceInfo;
        DeviceInfo deviceInfo12 = deviceInfo;
        DeviceInfo deviceInfo13 = deviceInfo;
        DeviceInfo deviceInfo14 = deviceInfo;
        DeviceInfo deviceInfo15 = deviceInfo;
        DeviceInfo deviceInfo16 = deviceInfo;
        DeviceInfo deviceInfo17 = deviceInfo;
        DeviceInfo deviceInfo18 = deviceInfo;
        DeviceInfo deviceInfo19 = deviceInfo;
        DeviceInfo deviceInfo20 = deviceInfo;
        return "\n        Version : " + (deviceInfo2 != null ? deviceInfo2.getVersionName() : null) + "\n        Package : " + (deviceInfo3 != null ? deviceInfo3.getPackageName() : null) + "\n        FilePath : " + (deviceInfo4 != null ? deviceInfo4.getFilePath() : null) + "\n        Phone Model" + (deviceInfo5 != null ? deviceInfo5.getPhoneModel() : null) + "\n        Android Version : " + (deviceInfo6 != null ? deviceInfo6.getAndroidVersion() : null) + "\n        Board : " + (deviceInfo7 != null ? deviceInfo7.getBoard() : null) + "\n        Brand : " + (deviceInfo8 != null ? deviceInfo8.getBrand() : null) + "\n        Device : " + (deviceInfo9 != null ? deviceInfo9.getDevice() : null) + "\n        Display : " + (deviceInfo10 != null ? deviceInfo10.getDisplay() : null) + "\n        Finger Print : " + (deviceInfo11 != null ? deviceInfo11.getFingerPrint() : null) + "\n        Host : " + (deviceInfo12 != null ? deviceInfo12.getHost() : null) + "\n        ID : " + (deviceInfo13 != null ? deviceInfo13.getID() : null) + "\n        Model : " + (deviceInfo14 != null ? deviceInfo14.getModel() : null) + "\n        Product : " + (deviceInfo15 != null ? deviceInfo15.getProduct() : null) + "\n        Tags : " + (deviceInfo16 != null ? deviceInfo16.getTags() : null) + "\n        Time : " + (deviceInfo17 != null ? Long.valueOf(deviceInfo17.getTime()) : null) + "\n        Type : " + (deviceInfo18 != null ? deviceInfo18.getType() : null) + "\n        User : " + (deviceInfo19 != null ? deviceInfo19.getUser() : null) + "\n        SDK_VERSION : " + (deviceInfo20 != null ? Integer.valueOf(deviceInfo20.getSdkInfo()) : null) + "\n        Total Internal memory :  + " + this.getTotalInternalMemory() + "\n        Available Internal memory : " + this.getAvailableInternalMemory() + "\n        ";
    }

    @Override
    public void uncaughtException(@Nullable Thread t, @Nullable Throwable exception) {
        Throwable cause;
        DeviceInfo deviceInfo = this.getDeviceInformation(this.context);
        String formattedString = this.formattedInfoString(deviceInfo);
        String report = "";
        Date curDate = new Date();
        report = report + "Error Report collected on : " + curDate.toString();
        report = report + "\n";
        report = report + "Information's :";
        report = report + "\n";
        if (userName != null) {
            report = report + "Username : " + userName;
            report = report + "\n";
        }
        if (userID != null) {
            report = report + "UserId : " + userID;
            report = report + "\n";
        }
        if (userEmail != null) {
            report = report + "UserEmail : " + userEmail;
            report = report + "\n";
        }
        report = report + "\n";
        report = report + "==============";
        report = report + "\n";
        report = report + "\n";
        report = report + formattedString;
        report = report + "\n\n";
        report = report + "Stack : \n";
        report = report + "======= \n";
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        Throwable throwable = exception;
        if (throwable != null) {
            throwable.printStackTrace(printWriter);
        }
        String stacktrace = result.toString();
        report = report + stacktrace;
        Throwable throwable2 = exception;
        Throwable throwable3 = cause = throwable2 != null ? throwable2.getCause() : null;
        if (cause != null) {
            report = report + "\n";
            report = report + "Cause : \n";
            report = report + "======= \n";
        }
        while (cause != null) {
            cause.printStackTrace(printWriter);
            report = report + result.toString();
            cause = cause.getCause();
        }
        printWriter.close();
        report = report + "****  End of current Report ***";
        if (this.context instanceof IPostTask) {
            IPostTask iPostTask = (IPostTask)this.context;
            Throwable throwable4 = exception;
            if (throwable4 == null) {
                Intrinsics.throwNpe();
            }
            iPostTask.postExceptionExecution(report, throwable4);
        }
    }

    private CrashLogger(Context context) {
        this.context = context;
    }

    static {
        Companion = new Companion(null);
        TAG = CrashLogger.class.getSimpleName();
    }

    public /* synthetic */ CrashLogger(@NotNull Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Nullable
    public static final /* synthetic */ String access$getUserName$cp() {
        return userName;
    }

    @Nullable
    public static final /* synthetic */ String access$getUserID$cp() {
        return userID;
    }

    @Nullable
    public static final /* synthetic */ String access$getUserEmail$cp() {
        return userEmail;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0006R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/crashlogger/android/CrashLogger$Companion;", "", "()V", "INSTANCE", "Lcom/crashlogger/android/CrashLogger;", "TAG", "", "getTAG", "()Ljava/lang/String;", "userEmail", "userID", "userName", "init", "context", "Landroid/content/Context;", "setUserEmail", "", "setUserIdentifier", "setUserName", "app_release"})
    public static final class Companion {
        @Nullable
        public final String getTAG() {
            return TAG;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final CrashLogger init(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            CrashLogger crashLogger = INSTANCE;
            if (crashLogger == null) {
                Companion companion = this;
                synchronized (companion) {
                    CrashLogger crashLogger2 = INSTANCE;
                    if (crashLogger2 == null) {
                        CrashLogger crashLogger3;
                        CrashLogger it = crashLogger3 = new CrashLogger(context, null);
                        INSTANCE = it;
                        crashLogger2 = crashLogger3;
                    }
                    CrashLogger crashLogger4 = crashLogger2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl15 : MonitorExitStatement: MONITOREXIT : var2_2
                    crashLogger = crashLogger4;
                }
            }
            Thread.setDefaultUncaughtExceptionHandler(INSTANCE);
            return INSTANCE;
        }

        public final void setUserName(@NotNull String userName) {
            Intrinsics.checkParameterIsNotNull((Object)userName, (String)"userName");
            userName = userName;
        }

        public final void setUserIdentifier(@NotNull String userID) {
            Intrinsics.checkParameterIsNotNull((Object)userID, (String)"userID");
            userID = userID;
        }

        public final void setUserEmail(@NotNull String userEmail) {
            Intrinsics.checkParameterIsNotNull((Object)userEmail, (String)"userEmail");
            userEmail = userEmail;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

