/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.audio;

import com.coze.openapi.api.AudioTranscriptionAPI;
import com.coze.openapi.client.audio.transcriptions.CreateTranscriptionsReq;
import com.coze.openapi.client.audio.transcriptions.CreateTranscriptionsResp;
import com.coze.openapi.client.common.BaseReq;
import com.coze.openapi.client.common.BaseResponse;
import com.coze.openapi.service.utils.Utils;
import java.io.File;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class TranscriptionService {
    private final AudioTranscriptionAPI transcriptionAPI;

    public TranscriptionService(AudioTranscriptionAPI transcriptionAPI) {
        this.transcriptionAPI = transcriptionAPI;
    }

    public CreateTranscriptionsResp create(CreateTranscriptionsReq req) {
        if (req.getFilePath() != null) {
            File file = new File(req.getFilePath());
            return this.uploadFile(file, file.getName(), req);
        }
        if (req.getFileBytes() != null) {
            return this.uploadFile(req.getFileBytes(), req.getFileName(), req);
        }
        if (req.getFile() != null) {
            return this.uploadFile(req.getFile(), req.getFileName(), req);
        }
        throw new IllegalArgumentException("file source is required");
    }

    private CreateTranscriptionsResp uploadFile(Object fileSource, String filename, BaseReq req) {
        RequestBody requestFile;
        MediaType mediaType;
        if (fileSource instanceof File) {
            mediaType = MediaType.parse((String)"multipart/form-data");
            requestFile = RequestBody.create((MediaType)mediaType, (File)((File)fileSource));
        } else {
            mediaType = MediaType.parse((String)"multipart/form-data");
            requestFile = RequestBody.create((MediaType)mediaType, (byte[])((byte[])fileSource));
        }
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)filename, (RequestBody)requestFile);
        BaseResponse<CreateTranscriptionsResp> resp = Utils.execute(this.transcriptionAPI.create(body, req));
        CreateTranscriptionsResp data = resp.getData();
        data.setLogID(resp.getLogID());
        return data;
    }
}

