/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.common;

import com.coze.openapi.client.common.BaseResponse;
import com.coze.openapi.client.exception.CozeApiException;
import com.coze.openapi.client.exception.CozeError;
import com.coze.openapi.service.service.common.CozeLoggerFactory;
import com.coze.openapi.service.utils.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.FlowableEmitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class AbstractEventCallback<T>
implements Callback<ResponseBody> {
    private static final ObjectMapper mapper = Utils.defaultObjectMapper();
    private static final Logger logger = CozeLoggerFactory.getLogger();
    private final ExecutorService backgroundExecutor;
    protected FlowableEmitter<T> emitter;

    public AbstractEventCallback(FlowableEmitter<T> emitter) {
        this.emitter = emitter;
        this.backgroundExecutor = Executors.newSingleThreadExecutor();
        emitter.setCancellable(this.backgroundExecutor::shutdownNow);
    }

    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
        this.backgroundExecutor.execute(() -> {
            BufferedReader reader = null;
            try {
                String line;
                String logID = Utils.getLogID(response);
                if (!response.isSuccessful()) {
                    logger.warn("HTTP error: " + response.code() + " " + response.message());
                    String errStr = response.errorBody().string();
                    CozeError error = (CozeError)mapper.readValue(errStr, CozeError.class);
                    CozeApiException exception = new CozeApiException(response.code(), error.getErrorMessage(), logID);
                    this.emitter.onError((Throwable)exception);
                    return;
                }
                String contentType = response.headers().get("Content-Type");
                if (contentType != null && contentType.contains("application/json")) {
                    block30: {
                        String respStr = ((ResponseBody)response.body()).string();
                        try {
                            BaseResponse baseResp = (BaseResponse)mapper.readValue(respStr, BaseResponse.class);
                            if (baseResp.getCode() == 0) break block30;
                            logger.warn("API error: {} {}", (Object)baseResp.getCode(), (Object)baseResp.getMsg());
                            CozeApiException exception = new CozeApiException(baseResp.getCode(), baseResp.getMsg(), logID);
                            this.emitter.onError((Throwable)exception);
                            return;
                        }
                        catch (Exception e) {
                            logger.error("Failed to parse JSON response: {}", (Object)respStr, (Object)e);
                            CozeApiException exception = new CozeApiException(-1, "Failed to parse JSON response: " + e.getMessage(), logID);
                            this.emitter.onError((Throwable)exception);
                            return;
                        }
                    }
                    this.emitter.onComplete();
                    return;
                }
                InputStream in = ((ResponseBody)response.body()).byteStream();
                reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                while (!this.emitter.isCancelled() && (line = reader.readLine()) != null && !this.processLine(line, reader, logID)) {
                }
                this.emitter.onComplete();
            }
            catch (Throwable t) {
                this.onFailure(call, t);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    if (response.body() != null) {
                        ((ResponseBody)response.body()).close();
                    }
                }
            }
        });
    }

    protected abstract boolean processLine(String var1, BufferedReader var2, String var3) throws IOException;

    public void onFailure(Call<ResponseBody> call, Throwable t) {
        try {
            this.emitter.onError(t);
        }
        finally {
            this.backgroundExecutor.shutdown();
        }
    }
}

