/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.chat;

import com.coze.openapi.api.ChatAPI;
import com.coze.openapi.api.ChatMessageAPI;
import com.coze.openapi.client.chat.CancelChatReq;
import com.coze.openapi.client.chat.CancelChatResp;
import com.coze.openapi.client.chat.CreateChatReq;
import com.coze.openapi.client.chat.CreateChatResp;
import com.coze.openapi.client.chat.RetrieveChatReq;
import com.coze.openapi.client.chat.RetrieveChatResp;
import com.coze.openapi.client.chat.SubmitToolOutputsReq;
import com.coze.openapi.client.chat.SubmitToolOutputsResp;
import com.coze.openapi.client.chat.message.ListMessageReq;
import com.coze.openapi.client.chat.message.ListMessageResp;
import com.coze.openapi.client.chat.model.Chat;
import com.coze.openapi.client.chat.model.ChatEvent;
import com.coze.openapi.client.chat.model.ChatPoll;
import com.coze.openapi.client.chat.model.ChatStatus;
import com.coze.openapi.client.common.BaseResp;
import com.coze.openapi.client.common.BaseResponse;
import com.coze.openapi.service.service.chat.ChatMessageService;
import com.coze.openapi.service.service.chat.EventCallback;
import com.coze.openapi.service.service.common.CozeLoggerFactory;
import com.coze.openapi.service.utils.Utils;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import retrofit2.Call;
import retrofit2.Callback;

public class ChatService {
    private final ChatAPI chatAPI;
    private final ChatMessageService chatMessageAPI;
    private static final Logger logger = CozeLoggerFactory.getLogger();

    public ChatService(ChatAPI chatAPI, ChatMessageAPI chatMessageAPI) {
        this.chatAPI = chatAPI;
        this.chatMessageAPI = new ChatMessageService(chatMessageAPI);
    }

    public ChatMessageService message() {
        return this.chatMessageAPI;
    }

    public CreateChatResp create(CreateChatReq req) {
        req.disableStream();
        String conversationID = req.getConversationID();
        req.clearBeforeReq();
        BaseResponse<Chat> resp = Utils.execute(this.chatAPI.chat(conversationID, req, req));
        return ((CreateChatResp.CreateChatRespBuilder)((BaseResp.BaseRespBuilder)CreateChatResp.builder().chat(resp.getData())).logID(resp.getLogID())).build();
    }

    public ChatPoll createAndPoll(CreateChatReq req) throws Exception {
        return this._createAndPoll(req, null);
    }

    public ChatPoll createAndPoll(CreateChatReq req, Long timeout) throws Exception {
        Objects.requireNonNull(timeout, "timeout is required");
        return this._createAndPoll(req, timeout);
    }

    private ChatPoll _createAndPoll(CreateChatReq req, Long timeout) throws Exception {
        req.disableStream();
        String conversationID = req.getConversationID();
        req.clearBeforeReq();
        Chat chat = Utils.execute(this.chatAPI.chat(conversationID, req, req)).getData();
        conversationID = chat.getConversationID();
        String chatID = chat.getID();
        long start = System.currentTimeMillis() / 1000L;
        while (ChatStatus.IN_PROGRESS.equals((Object)chat.getStatus())) {
            TimeUnit.SECONDS.sleep(1L);
            if (timeout != null && timeout > 0L && System.currentTimeMillis() / 1000L - start > timeout) {
                logger.warn("Chat timeout: " + timeout + " seconds, cancel Chat");
                this.cancel(CancelChatReq.of(conversationID, chatID));
                break;
            }
            chat = this.retrieve(RetrieveChatReq.of(conversationID, chatID)).getChat();
            if (!ChatStatus.COMPLETED.equals((Object)chat.getStatus())) continue;
            logger.info("Chat completed, spend " + (System.currentTimeMillis() / 1000L - start) + " seconds");
            break;
        }
        ListMessageResp resp = this.message().list(ListMessageReq.of(conversationID, chatID));
        return new ChatPoll(chat, resp.getMessages());
    }

    public RetrieveChatResp retrieve(RetrieveChatReq req) {
        BaseResponse<Chat> resp = Utils.execute(this.chatAPI.retrieve(req.getConversationID(), req.getChatID(), req));
        return ((RetrieveChatResp.RetrieveChatRespBuilder)((BaseResp.BaseRespBuilder)RetrieveChatResp.builder().chat(resp.getData())).logID(resp.getLogID())).build();
    }

    public CancelChatResp cancel(CancelChatReq req) {
        BaseResponse<Chat> resp = Utils.execute(this.chatAPI.cancel(req, req));
        return ((CancelChatResp.CancelChatRespBuilder)((BaseResp.BaseRespBuilder)CancelChatResp.builder().chat(resp.getData())).logID(resp.getLogID())).build();
    }

    public SubmitToolOutputsResp submitToolOutputs(SubmitToolOutputsReq req) {
        req.disableStream();
        String conversationID = req.getConversationID();
        String chatID = req.getChatID();
        req.clearBeforeReq();
        BaseResponse<Chat> resp = Utils.execute(this.chatAPI.submitToolOutputs(conversationID, chatID, req, req));
        return ((SubmitToolOutputsResp.SubmitToolOutputsRespBuilder)((BaseResp.BaseRespBuilder)SubmitToolOutputsResp.builder().chat(resp.getData())).logID(resp.getLogID())).build();
    }

    public Flowable<ChatEvent> streamSubmitToolOutputs(SubmitToolOutputsReq req) {
        req.enableStream();
        String conversationID = req.getConversationID();
        String chatID = req.getChatID();
        req.clearBeforeReq();
        return ChatService.stream(this.chatAPI.streamSubmitToolOutputs(conversationID, chatID, req, req));
    }

    public Flowable<ChatEvent> stream(CreateChatReq req) {
        req.enableStream();
        String conversationID = req.getConversationID();
        req.clearBeforeReq();
        return ChatService.stream(this.chatAPI.stream(conversationID, req, req));
    }

    public static Flowable<ChatEvent> stream(Call<ResponseBody> apiCall) {
        return Flowable.create(emitter -> apiCall.enqueue((Callback)new EventCallback((FlowableEmitter<ChatEvent>)emitter)), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }
}

